% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_sum.R
\name{net_sum}
\alias{net_sum}
\title{Extract Net Migration from an Origin-Destination Migration Flow Matrix.}
\usage{
net_sum(m, region = 1:dim(m)[1])
}
\arguments{
\item{m}{Matrix of origin-destination flows, where the first and second dimensions correspond to origin and destination respectively.}

\item{region}{Integer value corresponding to the region that the net migration sum is desired. Will return sums for all regions by default.}
}
\value{
Returns a numeric value of the sum of a single block.
}
\description{
Sums each regions flows (from origin rows and destination columns) to obtain net migration sums.
}
\examples{
m <- matrix(data = 1:16, nrow = 4, ncol = 4)
net_sum(m)
}
\seealso{
\code{\link{block_sum}}, \code{\link{sum_od}}
}
\author{
Guy J. Abel
}
