% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorProxy.R
\name{dict_recombinators_proxy}
\alias{dict_recombinators_proxy}
\alias{RecombinatorProxy}
\title{Proxy-Recombinator that Recombines According to its Configuration parameter}
\description{
Recombinator that performs the operation in its \code{operation} configuration parameter. This is useful, e.g., to make
\code{\link{OptimizerMies}}'s recombination operation fully parametrizable.
}
\section{Configuration Parameters}{

\itemize{
\item \code{operation} :: \code{\link{Recombinator}}\cr
Operation to perform. Must be set by the user.
This is primed when \verb{$prime()} of \code{RecombinatorProxy} is called, and also when \verb{$operate()} is called, to make changing
the operation as part of self-adaption possible. However, if the same operation gets used inside multiple \code{RecombinatorProxy}
objects, then it is recommended to \verb{$clone(deep = TRUE)} the object before assigning them to \code{operation} to avoid
frequent re-priming.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_lgl}} ('ParamLgl'), \code{\link[paradox:Domain]{p_int}} ('ParamInt'), \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl'), \code{\link[paradox:Domain]{p_fct}} ('ParamFct')
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("proxy")
recs("proxy")  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("proxy")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
rp = rec("proxy", operation = rec("xounif"))
p = ps(x = p_int(-5, 5), y = p_dbl(-5, 5), z = p_lgl())
data = data.frame(x = 1:4, y = 0:3, z = rep(TRUE, 4))

rp$prime(p)
rp$operate(data)  # default operation: null

rp$param_set$values$operation = rec("xounif", p = 0.5)
rp$operate(data)
}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xonary}},
\code{\link{dict_recombinators_xounif}}

Other recombinator wrappers: 
\code{\link{OperatorCombination}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_sequential}}
}
\concept{recombinator wrappers}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{RecombinatorProxy}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorProxy-new}{\code{RecombinatorProxy$new()}}
\item \href{#method-RecombinatorProxy-prime}{\code{RecombinatorProxy$prime()}}
\item \href{#method-RecombinatorProxy-clone}{\code{RecombinatorProxy$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorProxy-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorProxy-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{RecombinatorProxy} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorProxy$new(n_indivs_in = 2, n_indivs_out = n_indivs_in)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_indivs_in}}{(\code{integer(1)})\cr
Number of individuals to consider at the same time. When operating, the number of input individuals must be divisible by this number.
Furthermore, the \code{\link{Recombinator}} assigned to the \code{operation} configuration parameter must have an \code{n_indivs_in} that is a divisor of this number.
Default 2.\cr
The \verb{$n_indivs_in} field will reflect this value.}

\item{\code{n_indivs_out}}{(\code{integer(1)})\cr
Number of individuals that result for each \code{n_indivs_in} lines of input. Must be at most \code{n_indivs_in}.
The ratio of \verb{$n_indivs_in} to \verb{$n_indivs_out} of the \code{\link{Recombinator}} assigned to the \code{operation} configuration parameter must be the same as
\code{n_indivs_in} to \code{n_indivs_out} of this object.
Default equal to \code{n_indivs_in}.\cr
The \verb{$n_indivs_out} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorProxy-prime"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorProxy-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the operator given to the \code{operation} configuration parameter.
Note that this modifies the \verb{$param_set$values$operation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorProxy$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorProxy-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorProxy-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorProxy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
