% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FiltorMaybe.R
\name{dict_filtors_maybe}
\alias{dict_filtors_maybe}
\alias{FiltorMaybe}
\title{Filtor-Combination that Filters According to Two Filtors}
\description{
\code{\link{Filtor}} that wraps two other \code{\link{Filtor}}s given during construction and chooses which operation to perform.
Each of the resulting \code{n_filter} individuals is chosen either from \verb{$filtor}, or from \verb{$filtor_not}.

This makes it possible to implement filter methods such as random interleaving, where only a fraction of \code{p}
individuals were filtered and the others were not.

Letting the number of individuals chosen by \verb{$filtor} be \code{n_filter_f}, then \code{n_filter_f} is either fixed
set to \code{round(n_filter * p)}, (when \code{random_choise} is \code{FALSE}) or to \code{rbinom(1, n_filter, p)} (when \code{random_choice} is \code{TRUE}).

When \code{random_choice} is \code{FALSE}, then \verb{$needed_input()} is calculated directly from \verb{$needed_input()} of \verb{$filtor} and \verb{$filtor_not},
as well as \code{n_filter_f} and \code{n_filter - n_filter_f}.

When \code{random_choice} is \code{TRUE}, then \verb{$needed_input()} is considers the "worst case" from \verb{$filtor} and \verb{$filtor_not}, and assumes that
\verb{$needed_input()} is monotonically increasing in its input argument.

To make the worst case less extreme, the number of individuals chosen with \code{random_choice} set to \code{TRUE} is limited to
\code{qbinom(-20, n_filter, p, log.p = TRUE)} (with \code{lower.tail} \code{FALSE} and \code{TRUE} for \verb{$filtor} and \verb{$filtor_not}, respectively), which distorts the binomial
distribution with probability \code{1 - exp(-20)} or about \code{1 - 0.5e-9}.
}
\section{Configuration Parameters}{

This operator has the configuration parameters of the \code{\link{Filtor}}s that it wraps: The configuration parameters of the operator given to the \code{filtor} construction argument
are prefixed with \code{"maybe."}, the configuration parameters of the operator given to the \code{filtor_not} construction argument are prefixed with \code{"maybe_not."}.

Additional configuration parameters:
\itemize{
\item \code{p} :: \code{numeric(1)} \cr
Probability per individual (when \code{random_choise} is \code{TRUE}), or fraction of individuals (when \code{random_choice} is \code{FALSE}),
that are chosen from \verb{$filtor} instead of \verb{$filtor_not}. Must be set by the user.
\item \code{random_choice} :: \code{logical(1)} \cr
Whether to sample the number of individuals chosen by \verb{$filtor} according to \code{rbinom(1, n_filter, p)}, or to use a fixed fraction.
Initialized to \code{FALSE}.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are the set intersection of supported classes of \code{filtor} and \code{filtor_not}.
}

\section{Dictionary}{

This \code{\link{Filtor}} can be created with the short access form \code{\link[=ftr]{ftr()}}
(\code{\link[=ftrs]{ftrs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_filtors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
ftr("maybe", <filtor> [, <filtor_not>])
ftrs("maybe", <filtor> [, <filtor_not>])  # takes vector IDs, returns list of Filtors

# long form:
dict_filtors$get("maybe", <filtor> [, <filtor_not>])
}\if{html}{\out{</div>}}
}

\examples{
library("mlr3")
library("mlr3learners")

fm = ftr("maybe", ftr("surprog", lrn("regr.lm"), filter.pool_factor = 2), p = 0.5)
p = ps(x = p_dbl(-5, 5))
known_data = data.frame(x = 1:5)
fitnesses = 1:5
new_data = data.frame(x = c(0.5, 1.5, 2.5, 3.5, 4.5))

fm$prime(p)

fm$needed_input(2)

fm$operate(new_data, known_data, fitnesses, 2)

fm$param_set$values$p = 0.33

fm$needed_input(3)

fm$operate(new_data, known_data, fitnesses, 3)

}
\seealso{
Other filtors: 
\code{\link{FiltorSurrogate}},
\code{\link{Filtor}},
\code{\link{dict_filtors_null}},
\code{\link{dict_filtors_proxy}},
\code{\link{dict_filtors_surprog}},
\code{\link{dict_filtors_surtour}}

Other filtor wrappers: 
\code{\link{dict_filtors_proxy}}
}
\concept{filtor wrappers}
\concept{filtors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Filtor]{miesmuschel::Filtor}} -> \code{FiltorMaybe}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{filtor}}{(\code{\link{Filtor}})\cr
\code{\link{Filtor}} being wrapped. This operator gets run with probability / proportion \code{p} (configuration parameter).}

\item{\code{filtor_not}}{(\code{\link{Filtor}})\cr
Alternative \code{\link{Filtor}} being wrapped. This operator gets run with probability / proportion \code{1 - p} (configuration parameter).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FiltorMaybe-new}{\code{FiltorMaybe$new()}}
\item \href{#method-FiltorMaybe-prime}{\code{FiltorMaybe$prime()}}
\item \href{#method-FiltorMaybe-clone}{\code{FiltorMaybe$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="Filtor" data-id="needed_input"><a href='../../miesmuschel/html/Filtor.html#method-Filtor-needed_input'><code>miesmuschel::Filtor$needed_input()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorMaybe-new"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorMaybe-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{FiltorMaybe} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorMaybe$new(filtor, filtor_not = FiltorNull$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filtor}}{(\code{\link{Filtor}})\cr
\code{\link{Filtor}} to wrap. This operator gets run with probability \code{p} (Configuration parameter).\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$filtor} field will reflect this value.}

\item{\code{filtor_not}}{(\code{\link{Filtor}})\cr
Another \code{\link{Filtor}} to wrap. This operator runs when \code{filtor} is not chosen. By
default, this is \code{\link{FiltorNull}}, i.e. no filtering. With this default, the
\code{FiltorMaybe} object applies the \code{filtor} operation with probability / proportion \code{p}, and
no operation at all otherwise.\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$filtor_not} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorMaybe-prime"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorMaybe-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{filtor} and \code{filtor_not} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorMaybe$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorMaybe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorMaybe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorMaybe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
