% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_completion_status.R
\name{add_completion_status}
\alias{add_completion_status}
\title{Determine completion status for every student}
\usage{
add_completion_status(dframe, midfield_degree = degree)
}
\arguments{
\item{dframe}{Data frame of student-level records keyed by student ID.
Required variables are \code{mcid} and \code{timely_term.}}

\item{midfield_degree}{Data frame of student-level degree observations keyed
by student ID. Default is \code{degree.} Required variables are \code{mcid}
and \code{term_degree.}}
}
\value{
A \code{data.table} with the following properties:
\itemize{
\item Rows are not modified.
\item Grouping structures are not preserved.
\item Columns listed below are added. \strong{Caution!} An existing column
with the same name as one of the added columns is silently overwritten.
Other columns are not modified.
}
Columns added:
\describe{
\item{\code{term_degree}}{Character. Term in which the first degree(s) are
completed. Encoded YYYYT. Joined from \code{midfield_degree} data table.}
\item{\code{completion_status}}{Character. Label each observation to
indicate completion status. Possible values are: "timely", indicating
completion no later than the timely completion term; "late", indicating
completion after the timely completion term; and "NA" indicating
non-completion.}
}
}
\description{
Add columns to a data frame of student-level records that indicate whether a
student completed a degree, and if so, whether their completion was timely.
}
\details{
By "completion" we mean an undergraduate earning their first baccalaureate
degree (or degrees, for students earning more than one degree in the same
term). Additional degrees, if any, earned later than the term of the first
degree are ignored.

In many studies, students must complete a degree in a specified time span,
for example 4-, 6-, or 8-years after admission. If they do, their completion
is timely; if not, their completion is late and they are grouped with the
non-completers when computing a metric such as graduation rate.

Completion status is "timely" for students completing a degree no later than
their timely completion terms. See also \code{add_timely_term()}.
}
\examples{
# Start with an excerpt from the student data set 
dframe <- toy_student[1:10, .(mcid)]

# Timely term column is required to add completion status column
dframe <- add_timely_term(dframe, toy_term)

# Add completion status column
add_completion_status(dframe, toy_degree)

# Existing completion_status column, if any, is overwritten
dframe[, completion_status := NA_character_]
add_completion_status(dframe, toy_degree)
}
\seealso{
Other add_*: 
\code{\link{add_data_sufficiency}()},
\code{\link{add_timely_term}()}
}
\concept{add_*}
