% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkFunctions.R
\name{getIndividualParameters}
\alias{getIndividualParameters}
\title{sample subject specific parameters to input in pharmacodynamic model
paramaters are sample from a log-normal distribution}
\usage{
getIndividualParameters(meanParam, coeffVariation, nSubjects,
  corrMatrix = NULL)
}
\arguments{
\item{meanParam}{numeric vector containing mean information of a set of parameters}

\item{coeffVariation}{coefficient of variantion to inform the variance of the subject}

\item{nSubjects}{the number of subjects which should be sampled}

\item{corrMatrix}{optional correlation matrix when not specified parameters are assumed independent}
}
\value{
a matrix with rows subject and columns parameters
}
\description{
sample subject specific parameters to input in pharmacodynamic model
paramaters are sample from a log-normal distribution
}
\examples{
  parameters              <-  c( 1 , 0.1 , 10 , 3 )
  names( parameters )     <-  c( "Ka", "Ke" , "volume" , "dose" ) 
  coeffVariation          <-  c( 0.05 , 0.05 , 0.05, 0 )
  names(coeffVariation)   <-  names( parameters )
  nSubjects               <-  9

  # example correlation matrix 
  corrMatrix              <-  matrix(0.2 , nrow = 4 , ncol = 4) +
     diag( rep( 0.8 , 4 ) ) # correlation on the the log scale
  
  # assuming independence between parameters
  getIndividualParameters( parameters , coeffVariation ,  nSubjects = 9 )
  
  # assuming correlations between parameters 
  getIndividualParameters( parameters , coeffVariation ,  nSubjects = 9 , corrMatrix)
  getIndividualParameters( meanParam = parameters , coeffVariation ,  nSubjects = 3 , corrMatrix)


}
