% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex_tables.R
\name{tscat_apply}
\alias{tscat_apply}
\title{Multiple \code{TikZ} 2D scatter plots for a list of output comparisons.}
\usage{
tscat_apply(cmps, marks, tscale, before = "", after = "")
}
\arguments{
\item{cmps}{List of \code{\link{cmpoutput}} objects.}

\item{marks}{Character vector determining how to draw the points in
\code{TikZ}, for example: \code{
c("mark=square*,mark options={color=red},mark size=0.8pt",
  "mark=*,mark size=0.6pt",
  "mark=o,mark size=0.7pt")}.}

\item{tscale}{The \code{scale} property of the \code{TikZ} figure.}

\item{before}{\code{LaTeX} code to paste before each \code{TikZ} figure.}

\item{after}{\code{LaTeX} code to paste after each \code{TikZ} figure.}
}
\value{
List of TikZ 2D scatter plots corresponding to the comparisons
provided in \code{cmps}.
}
\description{
Produce multiple \code{TikZ} 2D scatter plots for a list of
\code{\link{cmpoutput}} objects.
}
\details{
This function is mainly to be used by the \code{\link{toLatex.micomp}}
method.
}
\keyword{internal}

