% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_nna.R
\name{prop_nna}
\alias{prop_nna}
\title{Calculates the posterior beta components for a
single proportion}
\usage{
prop_nna(x, data)
}
\arguments{
\item{x}{name of variable to calculate proportion.}

\item{data}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis').}
}
\value{
The posterior beta components.
}
\description{
\code{prop_nna} Calculates the posterior beta components
for a single proportion (assuming noninformative prior).
}
\examples{
 imp_dat <- df2milist(lbpmilr, impvar='Impnr')
 ra <- with(imp_dat, expr=prop_nna(Radiation))

}
\references{
Raghunathan, T. (2016). Missing Data Analysis in Practice.
Boca Raton, FL: Chapman and Hall/CRC. (paragr 4.6.2)
}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_prop_nna}}
}
\author{
Martijn Heymans, 2021
}
