% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_prop_wald.R
\name{pool_prop_wald}
\alias{pool_prop_wald}
\title{Calculates the pooled proportion and standard error according
to Wald across multiply imputed datasets.}
\usage{
pool_prop_wald(object, conf.level = 0.95, dfcom = NULL)
}
\arguments{
\item{object}{An object of class 'mistats' (repeated statistical
analysis across multiply imputed datasets).}

\item{conf.level}{Confidence level of the confidence intervals.}

\item{dfcom}{Complete data degrees of freedom. Default
number is taken from function \code{prop_wald}}
}
\value{
The proportion, the Confidence intervals, the standard error
and the statistic.
}
\description{
\code{pool_prop_wald} Calculates the pooled proportion and
standard error according to Wald across multiply imputed datasets
and using Rubin's Rules.
}
\details{
Before pooling, the proportions will be naturally log
transformed and the pooled estimates back transformed to the original scale.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=prop_wald(Radiation ~ 1))
res <- pool_prop_wald(ra)
res

}
\seealso{
\code{\link{with.milist}}, \code{\link{prop_wald}}
}
\author{
Martijn Heymans, 2021
}
