% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_mir.R
\name{extract_mir_string}
\alias{extract_mir_string}
\title{Extract miRNA names from string}
\usage{
extract_mir_string(string, threshold = 1, extract_letters = FALSE)
}
\arguments{
\item{string}{String. String to search for miRNA names.}

\item{threshold}{Integer. Specifies how often a miRNA must be mentioned in \code{string}
to be extracted.}

\item{extract_letters}{Boolean. If \code{extract_letters = FALSE}, only the miRNA stem
is extracted (e.g. \emph{miR-23}). If \code{extract_letters = TRUE}, the miRNA stem with
trailing letter (e.g. \emph{miR-23a}) is extracted.}
}
\value{
Character vector containing
miRNA names, if miRNA names are present in the string.
If no miRNA names are present in the string, a message
is returned saying \emph{"No miRNA found."}.
}
\description{
Extract miRNA names from a string.
}
\details{
Extract miRNA names from a string. miRNA names can
either be extracted with their stem only, e.g. \emph{miR-23}, or with their trailing
letter, e.g. \emph{miR-23a}. Furthermore, miRNA names are adapted to the most recent
miRBase
version (e.g. miR-97, miR-102, miR-180(a/b) become miR-30a, miR-29a,
and miR-172(a/b), respectively).
}
\seealso{
\code{\link[=extract_mir_df]{extract_mir_df()}}

Other extract functions: 
\code{\link{extract_mir_df}()},
\code{\link{extract_snp}()}
}
\concept{extract functions}
