% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metafeatures.R
\name{metafeatures}
\alias{metafeatures}
\alias{metafeatures.default}
\alias{metafeatures.formula}
\title{Extract meta-features from a dataset}
\usage{
metafeatures(...)

\method{metafeatures}{default}(x, y, groups = "default", summary = c("mean", "sd"), ...)

\method{metafeatures}{formula}(formula, data, groups = "default", summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Optional arguments to the summary methods.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{groups}{A list of meta-features groups, \code{"default"} for traditional
groups of meta-features or \code{"all"} to include all them. The details 
section describes the valid values for this parameter.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class
The details section describes the valid values for this group.}
}
\value{
A numeric vector named by the meta-features from the specified 
groups.
}
\description{
This is a simple way to extract the meta-features from a dataset, where all
meta-features from each group is extracted.
}
\details{
The following groups are allowed for this method:
 \describe{
   \item{"infotheo"}{Include all information theoretical meta-features. See
     \link{infotheo} for more details.}
   \item{"general"}{Include all general (simple) meta-features. See
     \link{general} for more details.}
   \item{"landmarking"}{Include all landmarking meta-features. See
     \link{landmarking} for more details.}
   \item{"model.based"}{Include all model based meta-features. See
     \link{model.based} for more details.}
   \item{"statistical"}{Include all statistical meta-features. See
     \link{statistical} for more details.}
   \item{"clustering"}{Include all clustering meta-features. See
     \link{clustering} for more details.}
   \item{"complexity"}{Include all complexity meta-features. See
     \link{complexity} for more details.}
   \item{"concept"}{Include all concept variation meta-features. See
     \link{concept} for more details.}
   \item{"itemset"}{Include all itemset meta-features. See
     \link{itemset} for more details.}
 }
}
\examples{
## Extract all meta-features
metafeatures(Species ~ ., iris)

## Extract some groups of meta-features
metafeatures(iris[1:4], iris[5], c("general", "statistical", "infotheo"))

## Use another summary methods
metafeatures(Species ~ ., iris, summary=c("min", "median", "max"))
}
