% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity.R
\name{complexity}
\alias{complexity}
\alias{complexity.default}
\alias{complexity.formula}
\title{Complexity meta-features}
\usage{
complexity(...)

\method{complexity}{default}(x, y, features = "all", summary = c("mean", "sd"), ...)

\method{complexity}{formula}(formula, data, features = "all", summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.
The supported values are described in the details section. (Default: 
\code{"all"})}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class}
}
\value{
A list named by the requested meta-features.
}
\description{
The complexity group is a set of measures to characterize the complexity of 
classification problems based on aspects that quantify the linearity of the 
data, the presence of informative feature, the sparsity and dimensionality 
of the datasets.
}
\details{
The following features are allowed for classification problems:
 \describe{
   \item{"C1"}{Entropy of class proportions.}
   \item{"C2"}{Multi-class imbalance ratio.}
   \item{"F1"}{Fisher's discriminant ratio.}
   \item{"F1v"}{The directional-vector Fisher's discriminant ratio.}
   \item{"F2"}{Overlapping of the per-class bounding boxes.}
   \item{"F3"}{Maximum individual feature efficiency.}
   \item{"F4"}{Collective feature efficiency.}
   \item{"L1"}{Distance of erroneous instances to a linear classifier.}
   \item{"L2"}{Training error of a linear classifier.}
   \item{"L3"}{Nonlinearity of a linear classifier.}
   \item{"LSC"}{Local-Set cardinality average.}
   \item{"N1"}{Fraction of points lying on the class boundary.}
   \item{"N2"}{Average intra/inter class nearest neighbor distances.}
   \item{"N3"}{Leave-one-out error rate of the 1-nearest neighbor algorithm.}
   \item{"N4"}{Nonlinearity of the one-nearest neighbor classifier.}
   \item{"T1"}{Fraction of maximum covering spheres on data.}
   \item{"T2"}{Average number of samples per dimension.}
   \item{"T3"}{Average intrinsic dimensionality per number of examples.}
   \item{"T4"}{Intrinsic dimensionality proportion.}
 }
 Also it is possible to ask for a subgroup of features:
 \describe{
    \item{"balance"}{Include the measures C1 and C2.}
    \item{"dimensionality"}{Include the measures T2, T3 and T4.}
    \item{"linearity"}{Include the measures L1, L2 and L3.}
    \item{"neighborhood"}{Include the measures N1, N2, N3, N4, T1 and LSC.}
    \item{"network"}{Include the measures Density, ClsCoef and Hubs.}
    \item{"overlapping"}{Include the measures F1, F1v, F2, F3 and F4.}
 }
}
\examples{
## Extract all metafeatures
complexity(Species ~ ., iris)

## Extract some metafeatures
complexity(iris[30:120, 1:4], iris[30:120, 5], c("F1", "F2", "linearity"))
}
\references{
Ana C. Lorena, Luis P. F. Garcia, Jens Lehmann, Marcilio C. P. Souto, and 
 Tin Kam Ho. 2019. How Complex Is Your Classification Problem?: A Survey on 
 Measuring Classification Complexity. ACM Comput. Surv. 52, 5.

 Lorena, A. C., Maciel, A. I., de Miranda, P. B. C., Costa, I. G., and 
 Prudencio, R. B. C. (2018). Data complexity meta-features for regression 
 problems. Machine Learning, 107(1):209-246.

 Ho, T., and Basu, M. (2002). Complexity measures of supervised 
 classification problems. IEEE Transactions on Pattern Analysis and 
 Machine Intelligence, 24(3):289-300.
}
\seealso{
Other meta-features: 
\code{\link{clustering}()},
\code{\link{concept}()},
\code{\link{general}()},
\code{\link{infotheo}()},
\code{\link{itemset}()},
\code{\link{landmarking}()},
\code{\link{model.based}()},
\code{\link{relative}()},
\code{\link{statistical}()}
}
\concept{meta-features}
