% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.rmevspec_cpp}
\alias{.rmevspec_cpp}
\title{Random sampling from spectral distribution on l1 sphere}
\usage{
.rmevspec_cpp(n, d, para, model, Sigma, loc)
}
\arguments{
\item{n}{sample size}

\item{d}{dimension of the multivariate distribution}

\item{model}{integer, currently ranging from 1 to 9, corresponding respectively to
(1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
(5) \code{extstud}, (6) \code{br}, (7) \code{ct} and \code{sdir}, (8) \code{smith} and (9) \code{hr}.}

\item{Sigma}{covariance matrix for Brown-Resnick and extremal student, symmetric matrix
of squared coefficients \eqn{\lambda^2} for Husler-Reiss. Default for compatibility}

\item{loc}{matrix of locations for the Smith model}

\item{param}{a vector of parameters}
}
\value{
a \code{n} by \code{d} matrix containing the sample
}
\description{
Generate from \eqn{Q_i}{Qi}, the spectral measure of a given multivariate extreme value model
}
\references{
Dombry, Engelke and Oesting (2016). Exact simulation of max-stable processes,
\emph{Biometrika}, \bold{103}(2), 303--317.

Boldi (2009). A note on the representation of parametric models for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
}
\keyword{internal}
