% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmvn.R
\name{pmvn}
\alias{pmvn}
\alias{pbvn}
\alias{loglikMVN}
\alias{scoreMVN}
\title{Multivariate normal distribution function}
\usage{
pmvn(lower, upper, mu, sigma, cor = FALSE)
}
\arguments{
\item{lower}{lower limits}

\item{upper}{upper limits}

\item{mu}{mean vector}

\item{sigma}{variance matrix or vector of correlation coefficients}

\item{cor}{if TRUE sigma is treated as standardized (correlation matrix)}
}
\description{
Multivariate normal distribution function
}
\examples{
lower <- rbind(c(0,-Inf),c(-Inf,0))
upper <- rbind(c(Inf,0),c(0,Inf))
mu <- rbind(c(1,1),c(-1,1))
sigma <- diag(2)+1
pmvn(lower=lower,upper=upper,mu=mu,sigma=sigma)
}
\seealso{
dmvn rmvn
}
