% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_Erel.R
\name{Erel}
\alias{Erel}
\title{Relative Model Efficiency (Erel)}
\usage{
Erel(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the Erel model efficiency using differences to observations.
}
\details{
The Erel model efficiency normalizes both residuals (numerator) and observed
deviations (denominator) by observed values before squaring them. Compared to the NSE, the Erel is suggested as
more sensitive to systematic over- or under-predictions.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
Erel(obs = X, pred = Y)
}
}
\references{
Krause et al. (2005).
Comparison of different efficiency criteria for hydrological model assessment.
\emph{Adv. Geosci. 5, 89–97.} \doi{10.5194/adgeo-5-89-2005}
}
