% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uc.R
\name{Uc}
\alias{Uc}
\title{Lack of Consistency (Uc)}
\usage{
Uc(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the Uc component from the sum of squares decomposition
described by Smith & Rose (1995).
}
\details{
The Uc estimates the proportion of the total sum of squares related to the
lack of consistency (proportional bias) following the sum of squares decomposition
suggested by Smith and Rose (1995) also known as Theil's partial inequalities.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
Uc(obs = X, pred = Y)
}
}
\references{
Smith & Rose (1995).
Model goodness-of-fit analysis using regression and related techniques.
\emph{Ecol. Model. 77, 49–64.} \doi{10.1016/0304-3800(93)E0074-D}
}
