% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/killSomeBig.R
\name{killSomeBig}
\alias{killSomeBig}
\title{Remove most closely related individuals for large arenas}
\usage{
killSomeBig(tree, arena.output, max.distance, proportion.killed)
}
\arguments{
\item{tree}{Phylo object}

\item{arena.output}{A spatial arena with three columns: individuals (the species ID), 
X (the x axis location of that individual), and Y (the y axis location). The
arena.output actually needs a number of other elements in order for later functions to
work properly, so any modifications to the code should take note of this.}

\item{max.distance}{The geographic distance within which geographically neighboring
indivduals should be considered to influence the individual in question.}

\item{proportion.killed}{The percent of individuals in the total arena that should be
considered (as a proportion, e.g. 0.5 = half).}
}
\value{
A list of 5 elements: the average relatedness in the geographic neighbordhood
of consideration (appended to any previous values that were fed into the function), 
the number of individuals killed, the original input regional
abundance vector, the new spatial arena, and the dimensions of that arena.
}
\description{
Given a phylogenetic tree, a large spatial arena of individuals with species
identities, and arguments for the desired distance and percent removed, removes some of
the most closely related individuals in the arena.
}
\details{
This function identifies individuals in the most genetically clustered
geographic neighborhoods, continues on to identify the most closely related individual
to a focal individual, and randomly chooses whether to remove that individual or the
focal individual. It expects a list with a number of additional elements beyond the 
arena (currently, the mean genetic relatedness of geographic neighborhoods, a vector of
regional abundance [where each element is a species name, repeated as many times as is
present in pool], and the dimensions of the arena). This function is invoked if the
number of individuals in the arena exceeds 50,000. It was originally intended only for 
arenas with large numbers of individuals, but it ends up being faster than the original
version of the function for all but the smallest arenas. That said, if the local area
within the arena that the function considers does not contain any individuals, then it
will fail. To overcome this, either a larger max.distance would need to be set, or more
individuals should be settled in the arena, or the original version of the function
should be invoked by modifying the code in competitionArena(). Note, however, that if 
there are more than e.g. 50,000 individuals total in the arena, the original version of
the function should never be used, or all memory in the computer will be used and it
will crash.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

#prep the data for the simulation
prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=1, 
length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
competition.iterations=5)

#use the random simulation to generate a starting arena
random <- randomArena(prepped)

#in normal use, these parameters will be carried down from the simulations.input object
new.arena <- killSomeBig(tree, arena.output=random, max.distance=50, 
proportion.killed=0.2)

#look at how number of individuals in arena changes
dim(random$arena)
dim(new.arena$arena)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
