% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/varyX.R
\name{varyX}
\alias{varyX}
\title{Calculate alpha or beta metrics across a set of parameters}
\usage{
varyX(alpha = TRUE, tree.size, richness, delta, abundances, beta.iterations,
  iterations, cores)
}
\arguments{
\item{alpha}{Whether to calculate alpha or beta phylogenetic community structure
metrics. Default is TRUE. Set to FALSE for beta metrics.}

\item{tree.size}{Either a single number, or if the aim is to vary tree size while
holding other parameters constant, then a list of numbers of species desired in each
total tree. If provided as a vector of numbers, will be coerced to a list.}

\item{richness}{Either the number of species to be placed in each plot, or if the aim
is to vary richness while holding other parameters constant, then a list of vectors of
number of species to be placed in each plot. See examples.}

\item{delta}{Either a value for the delta transformation (Pagel 1999), or if the aim is
to vary tree shape while holding other parameters constant, then a list of numbers of
delta transformations. If provided as a vector of numbers, will be coerced to a list.
Values greater than 1 push the branching events towards the root, while values less
than 1 push the branching events closer to the tips. See details for particularly low
delta values.}

\item{abundances}{Either a vector of abundances, or if the aim is to vary the abundance
distribution function, then a list of vectors of abundances. See examples.}

\item{beta.iterations}{Because the type of beta-level phylogenetic community structure
metrics used here return a single value per community data matrix, it is not possible
to look for inter-metric correlations with only a single matrix and tree. To deal with
this, the same tree can be used with different community data matrices. This argument
specifies the number of matrices to be used per tree. Not needed if alpha=TRUE.}

\item{iterations}{How many times to simulate the given set of parameters. For instance,
with a single tree size, richness.vector, delta, and two sets of abundances, and 10
iterations, the result will be a list with 10 elements. Each of those 10 elements will
be a list of two elements, each of which will be the calculated metrics for a given
set of parameters (one for each abundance vector).}

\item{cores}{Number of cores to be used for parallel processing. The iteration aspect
of the function is parallelized, so for efficiency purposes, it is best to run this
over numerous iterations rather than repeating the same parameter numerous times (e.g.,
rather than setting deltas to rep(1, 10), set delta to 1 and iterations to 10).}
}
\value{
A list of lists of data frames.
}
\description{
Takes a specified set of parameters, and holds those constant while varying one of
the parameters to see variance in community structure metrics.
}
\details{
If given a small value, e.g. 0.1, the delta parameter
(tree shape) can occasionally result in oddly formatted trees that would cause errors.
To deal with this, there is an internal check that will recreate a new tree and
re-scale it with the desired delta. This has not been tested at delta < 0.1, and is
currently programmed with a while loop. Care should be taken not to get R stuck in an
indefinite loop at delta values even lower than 0.1
}
\examples{
#example of how to vary tree size
system.time(temp <- varyX(alpha=TRUE, tree.size=c(59, 100),
	richness=40:59, delta=1,
	abundances=round(rlnorm(5000, meanlog=2, sdlog=1)) + 1, iterations=2, cores=1))

#example of how to vary richness
#not run
#system.time(temp <- varyX(alpha=TRUE, tree.size=59,
	#richness=list(30:39, 40:49), delta=1,
	#abundances=round(rlnorm(5000, meanlog=2, sdlog=1)) + 1, iterations=2, cores=1))

#example of how to vary tree shape
#not run
#system.time(temp <- varyX(alpha=TRUE, tree.size=59,
	#richness=40:59, delta=c(0.1,10),
	#abundances=round(rlnorm(5000, meanlog=2, sdlog=1)) + 1, iterations=2, cores=1))

#example of how to vary abundance
#not run
#inputAbunds <- list(rep(2,5000), (round(rnorm(5000, 50, 15)) + 1),
	#(round(rlnorm(5000, meanlog=2, sdlog=1)) + 1))

#system.time(temp <- varyX(alpha=TRUE, tree.size=59,
	#richness=40:59, delta=1, abundances=inputAbunds, iterations=2, cores=1))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

