% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvial_plot.R
\name{alluvial_cluster_plot}
\alias{alluvial_cluster_plot}
\title{Alluvial plot of patients across cluster counts and important features}
\usage{
alluvial_cluster_plot(
  cluster_sequence,
  similarity_matrix,
  dl = NULL,
  data = NULL,
  key_outcome,
  key_label = key_outcome,
  extra_outcomes = NULL,
  title = NULL
)
}
\arguments{
\item{cluster_sequence}{A list of clustering algorithms.}

\item{similarity_matrix}{A similarity matrix.}

\item{dl}{A data list.}

\item{data}{A data frame that contains any features to include in the plot.}

\item{key_outcome}{The name of the feature that determines how each patient
stream is coloured in the alluvial plot.}

\item{key_label}{Name of key outcome to be used for the plot legend.}

\item{extra_outcomes}{Names of additional features to add to the plot.}

\item{title}{Title of the plot.}
}
\value{
An alluvial plot (class "gg" and "ggplot") showing distribution of
a feature across varying number cluster solutions.
}
\description{
This function creates an alluvial plot that shows how observations in
a similarity matrix could have been clustered over a set of clustering
functions.
}
\examples{
input_dl <- data_list(
    list(gender_df, "gender", "demographics", "categorical"),
    list(diagnosis_df, "diagnosis", "clinical", "categorical"),
    uid = "patient_id"
)

sc <- snf_config(input_dl, n_solutions = 1)

sol_df <- batch_snf(input_dl, sc, return_sim_mats = TRUE)

sim_mats <- sim_mats_list(sol_df)

clust_fn_sequence <- list(spectral_two, spectral_four)

alluvial_cluster_plot(
    cluster_sequence = clust_fn_sequence,
    similarity_matrix = sim_mats[[1]],
    dl = input_dl,
    key_outcome = "gender",
    key_label = "Gender",
    extra_outcomes = "diagnosis",
    title = "Gender Across Cluster Counts"
)
}
