% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{dens.data.frame}
\alias{dens.data.frame}
\title{Dens Method for Data Frame}
\usage{
\method{dens}{data.frame}(x, ..., xlab = NULL, ref = NULL, log = FALSE,
  aspect = 1, scales = NULL, panel = NULL,
  fun = getOption("metaplot_dens", "dens_data_frame"))
}
\arguments{
\item{x}{data.frame}

\item{...}{item to plot, given as unquoted column name}

\item{xlab}{x axis label}

\item{ref}{optional numeric}

\item{log}{whether to use log scale}

\item{aspect}{passed to \code{\link[lattice]{densityplot}}}

\item{scales}{passed to \code{\link[lattice]{densityplot}}}

\item{panel}{passed to \code{\link[lattice]{densityplot}}}

\item{fun}{function that does the actual plotting}
}
\description{
Plot density for object of class 'data.frame'. Uses nonstandard evaluation.
}
\examples{
dens(Theoph, Wt, grid = TRUE )
}
\seealso{
Other univariate plots: \code{\link{dens.folded}},
  \code{\link{dens_data_frame}},
  \code{\link{metaplot.data.frame}},
  \code{\link{metaplot.folded}}

Other dens: \code{\link{dens.folded}},
  \code{\link{dens_data_frame}}
}
