% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ecovalence.R
\name{print.ecovalence}
\alias{print.ecovalence}
\title{Print an object of class ecovalence}
\usage{
\method{print}{ecovalence}(x, export = FALSE, file.name = NULL, digits = 3, ...)
}
\arguments{
\item{x}{The \code{ecovalence} x}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported to
the working directory.}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print the \code{ecovalence} object in two ways. By default, the results
are shown in the R console. The results can also be exported to the directory
into a *.txt file.
}
\examples{

library(metan)
eco <- ecovalence(data_ge2,
  env = ENV,
  gen = GEN,
  rep = REP,
  resp = PH
)
print(eco)
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
