% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coincidence_index.R
\name{print.coincidence}
\alias{print.coincidence}
\title{Print an object of class coincidence}
\usage{
\method{print}{coincidence}(x, export = FALSE, file.name = NULL, digits = 4, ...)
}
\arguments{
\item{x}{An object of class \code{coincidence}.}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported
to the working directory}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print a \code{coincidence} object in two ways. By default, the results are shown in
the R console. The results can also be exported to the directory.
}
\examples{
\donttest{
library(metan)
sel1 <- paste("G", 1:30, sep = "")
sel2 <- paste("G", 16:45, sep = "")
coinc <- coincidence_index(sel1 = sel1, sel2 = sel2, total = 150)
print(coinc)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
