% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valmeta.r
\name{plot.valmeta}
\alias{plot.valmeta}
\title{Forest Plots}
\usage{
\method{plot}{valmeta}(x, sort = "asc", ...)
}
\arguments{
\item{x}{An object of class \code{"valmeta"}}

\item{sort}{By default, studies are ordered by ascending effect size (\code{sort="asc"}). For study ordering by descending
effect size, choose \code{sort="desc"}. For any other value, study ordering is ignored.}

\item{\ldots}{Additional arguments which are passed to \link{forest}.}
}
\value{
An object of class \code{ggplot}
}
\description{
Function to create forest plots for objects of class \code{"valmeta"}.
}
\details{
The forest plot shows the performance estimates of each validation with corresponding confidence 
intervals. A polygon is added to the bottom of the forest plot, showing the summary estimate based on the model. 
A 95\% prediction interval is added by default for random-effects models,  the dotted line indicates its (approximate) bounds.
}
\examples{
data(EuroSCORE)
fit <- with(EuroSCORE, valmeta(cstat=c.index, cstat.se=se.c.index, 
            cstat.95CI=cbind(c.index.95CIl,c.index.95CIu), N=n, O=n.events))
plot(fit)

library(ggplot2)
plot(fit, theme=theme_grey())

}
\references{
\itemize{
\item Debray TPA, Damen JAAG, Snell KIE, Ensor J, Hooft L, Reitsma JB, et al. A guide to systematic review 
and meta-analysis of prediction model performance. \emph{BMJ}. 2017;356:i6460.
\item Lewis S, Clarke M. Forest plots: trying to see the wood and the trees. \emph{BMJ}. 2001; 322(7300):1479--80.
\item Riley RD, Higgins JPT, Deeks JJ. Interpretation of random effects meta-analyses. \emph{BMJ}. 2011 342:d549--d549.
}
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{calibration}
\keyword{discrimination}
\keyword{forest}
\keyword{meta-analysis}
