% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_studies.R
\name{describe_studies}
\alias{describe_studies}
\title{Descriptive statistics for meta-analyzing studies reporting medians}
\usage{
describe_studies(data, method = "qe", group_labels = c("Group 1", "Group 2"))
}
\arguments{
\item{data}{data frame containing the study-specific summary data. For one-group studies, this data frame can contain the following columns:
\tabular{ll}{
\code{min.g1} \tab minimum value. \cr
\code{q1.g1} \tab first quartile. \cr
\code{med.g1} \tab median. \cr
\code{q3.g1} \tab third quartile. \cr
\code{max.g1} \tab maximum value. \cr
\code{n.g1} \tab sample size. \cr
\code{mean.g1} \tab sample mean. \cr
\code{sd.g1} \tab sample standard deviation. \cr
\code{med.var.g1} \tab sampling variance of the median (only applicable when \code{median_method="cd"}). \cr
\code{med.ci.lb.g1} \tab lower confidence interval bound around the median (only applicable when \code{median_method="cd"}). \cr
\code{med.ci.ub.g1} \tab upper confidence interval bound around the median (only applicable when \code{median_method="cd"}). \cr
\code{alpha.1.g1} \tab \eqn{\alpha_1} values from Ozturk and Balakrishnan (2020) (only applicable when \code{median_method="cd"}). \cr
\code{alpha.2.g1} \tab \eqn{\alpha_2} values from Ozturk and Balakrishnan (2020) (only applicable when \code{median_method="cd"}). \cr}
For two group studies, this data frame can also contain the following columns for the summary data of the second group: \code{min.g2}, \code{q1.g2}, \code{med.g2}, \code{q3.g2}, \code{max.g2}, \code{n.g2}, \code{mean.g2}, and \code{sd.g2}.}

\item{method}{character string specifying the sets of summary statistics to consider. If this argument is set to \code{"cd"}, the summary statistics for the CD method (see C1/C2, C3, C4, C5 in \code{\link{cd}}) are considered. Otherwise, the S1, S2, S3, and S4 summary statistics described in \code{\link{qe}} are considered.}

\item{group_labels}{vector of character strings specifying the names corresponding to groups 1 and 2, respectively. This argument is only applicable when the meta-analysis consists of two-group studies. By default, this argument is set to \code{c('Group 1', 'Group 2')}.}
}
\value{
an object of class \code{"describe_studies"}. The object is a list with the following components:
\item{description}{data frame containing the results of the descriptive analyses.}
\item{bowley_g1}{vector containing the study-specific Bowley skewness values in group 1.}
\item{bowley_g2}{vector containing the study-specific Bowley skewness values in group 2.}
\item{skew_test_g1}{data frame containing the results of the skewness test of Shi et al. (2023) based on the group 1 data. The data frame contains the test statistic values, critical values at the 0.05 level, and indicators of statistical significance at the 0.05 level.}
\item{skew_test_g2}{data frame containing the results of the skewness test of Shi et al. (2023) based on the group 2 data. The data frame contains the test statistic values, critical values at the 0.05 level, and indicators of statistical significance at the 0.05 level.}
The results are printed with the \code{\link{print.describe_studies}} function.
}
\description{
This function performs some descriptive analyses. Specifically, this function describes: (i) the number of studies reporting various summary statistics, (ii) the Bowley skewness (Bowley, 1901) in the primary studies, and (iii) the results of a skewness test (Shi et al., 2023) applied to the summary statistics reported in the primary studies.
}
\examples{
describe_studies(data = dat.age, group_labels = c("Nonsurvivors", "Survivors"))

}
\references{
Bowley, A.L. (1901). Elements of Statistics. London: P.S. King & Son.

Shi J., Luo D., Wan X., Yue L., Liu J., Bian Z., Tong T. (2023). Detecting the skewness of data from the five-number summary and its application in meta-analysis. \emph{Statistical Methods in Medical Research}. \strong{0}(0).
}
