% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/react_disposition.R
\name{react_disposition}
\alias{react_disposition}
\title{Display interactive disposition tables with AE subgroup analysis}
\usage{
react_disposition(
  metadata_sl,
  metadata_ae,
  analysis = "disp",
  population = metadata_sl$plan[metadata_sl$plan$analysis == analysis, ]$population,
  sl_parameter = paste(metadata_sl$plan[metadata_sl$plan$analysis == analysis,
    ]$parameter, collapse = ";"),
  display_total = TRUE,
  width = 1200
)
}
\arguments{
\item{metadata_sl}{A metadata created by metalite,
which builds the baseline characteristic table}

\item{metadata_ae}{A metadata created by metalite,
which builds the AE subgroup specific table}

\item{analysis}{The analysis label provided in \code{metadata_sl}.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{sl_parameter}{A character value of parameter term name for
the baseline characteristic table.
The term name is used as key to link information.}

\item{display_total}{Display total column or not.}

\item{width}{A numeric value of width of the table in pixels.}
}
\value{
An reactable combing both baseline characteristic table
and AE subgroup specific tables.
}
\description{
Display interactive disposition tables with AE subgroup analysis
}
\examples{
if (interactive()) {
  react_disposition(
    metadata_sl = meta_sl_example(),
    metadata_ae = metalite.ae::meta_ae_example(),
    width = 1200
  )
}
}
