% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlf_ae_specific.R
\name{tlf_ae_specific}
\alias{tlf_ae_specific}
\title{Specific adverse events table}
\usage{
tlf_ae_specific(
  outdata,
  meddra_version,
  source,
  col_rel_width = NULL,
  text_font_size = 9,
  orientation = "portrait",
  footnotes = NULL,
  title = NULL,
  path_outdata = NULL,
  path_outtable = NULL
)
}
\arguments{
\item{outdata}{A outdata list created from \code{\link[=prepare_ae_specific]{prepare_ae_specific()}}.}

\item{meddra_version}{A character value of the MedDRA version
for this dataset.}

\item{source}{A character value of the data source.}

\item{col_rel_width}{Column relative width in a vector e.g. c(2,1,1) refers to 2:1:1.
Default is NULL for equal column width.}

\item{text_font_size}{Text font size.  To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{orientation}{Orientation in 'portrait' or 'landscape'.}

\item{footnotes}{A character vector of table footnotes.}

\item{title}{A character vector of table titles.}

\item{path_outdata}{A character string of the outdata path.}

\item{path_outtable}{A character string of the outtable path.}
}
\value{
RTF file and source dataset for AE specific table.
}
\description{
Specific adverse events table
}
\examples{
meta <- meta_ae_example()

meta |>
  prepare_ae_specific(
    population = "apat",
    observation = "wk12",
    parameter = "rel"
  ) |>
  format_ae_specific() |>
  tlf_ae_specific(
    source = "Source:  [CDISCpilot: adam-adsl; adae]",
    meddra_version = "24.0",
    path_outdata = tempfile(fileext = ".Rdata"),
    path_outtable = tempfile(fileext = ".rtf")
  )
}
