% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_dt.R
\name{sens_dt}
\alias{sens_dt}
\alias{heatplot}
\title{Sensitivity analysis (based on decision thresholds) for the Decision
Inconsistency and Across-Studies Inconsistency index}
\usage{
sens_dt(x, br = NULL, min1, max1, min2, max2, sm, by = 1, scale = 1000)

heatplot(x, limits1 = NULL, limits2 = NULL, ...)
}
\arguments{
\item{x}{An R object created with \code{\link{getsamples}} or a matrix
containing the samples of the effect sizes of primary
studies. Note that log-transformed effect sizes must be provided
(e.g., log odds ratios instead of odds ratios).}

\item{br}{Baseline risk.}

\item{min1}{A single numeric defining the lowest value for the
lower decision threshold. Must be lower than \code{max1},
\code{min2} and \code{max2}.}

\item{max1}{A single numeric defining the highest value for the
lower decision threshold. Must be higher than \code{min1}, but
lower than \code{min2} and \code{max2}.}

\item{min2}{A single numeric defining the lowest value for the
higher decision threshold. Must be higher than \code{min1} and
\code{max1}, but lower than \code{max2}.}

\item{max2}{A single numeric defining the highest value for the
higher decision threshold. Must be higher than \code{min1},
\code{max1} and \code{min2}.}

\item{sm}{A character string indicating the summary measure used in
primary studies (either \code{sm = "OR"}, \code{sm = "RR"} or
\code{sm = "HR"}).}

\item{by}{Increment of the sequences from \code{min1} to
\code{max1} and \code{min2} to \code{max2}.}

\item{scale}{The number of people per which absolute decision
thresholds are provided (default: 1000, i.e., absolute decision
threshold values are defined per 1000 people).}

\item{limits1}{Limits for the colour range in the heatplot showing
the Decision Inconsistency index.}

\item{limits2}{Limits for the colour range in the heatplot showing
the Across-Studies Inconsistency index.}

\item{\dots}{Additional graphical arguments (ignored).}
}
\value{
A data frame containing
\item{dt1}{Lower decision threshold}
\item{dt2}{Higher decision threshold}
\item{ASI}{Decision Inconsistency index for each combination of decision thresholds}
\item{DI}{Across-Studies Inconsistency index for each combination of decision thresholds}
}
\description{
Sensitivity analysis on the Decision Inconsistency index and the
Across-Studies Inconsistency index based on a range of decision thresholds
distinguishing meaningful versus trivial effects. It is applicable only to 
meta-analyses with binary outcome data (effect size measures expressed as 
risk ratios, odds ratios or hazard ratios).
}
\details{
Computes the Decision Inconsistency index
(DI) and the Across-Studies Inconsistency index (ASI) across a range of 
decision thresholds distinguishing meaningful vs trivial effects. This
function can only be applied to dichotomous outcomes expressed as (log-) odds
ratio, risk ratio and hazard ratio.
Graphical representations can be obtained using the \code{heatplot} function.
}
\examples{
\donttest{
data(anticoagulation)
dis <- sens_dt(log(anticoagulation),
  br = 0.5, min1 = -20, max1 = -10, min2 = 10, max2 = 20, sm = "or")
#
head(dis)
summary(dis$DI)
summary(dis$ASI)

heatplot(dis)
}

}
\references{
Schunemann HJ, Higgins JPT, Vist GE, et al. (2019).
\dQuote{Completing ‘Summary of findings’ tables and grading the certainty of
the evidence.}
\emph{Cochrane Handbook for Systematic Reviews of Interventions},
375--402.

Skoetz N, Goldkuhle M, van Dalen EC, et al. (2020).
\dQuote{GRADE guidelines 27: how to calculate absolute effects for
time-to-event outcomes in summary of findings tables and Evidence Profiles.}
\emph{Journal of Clinical Epidemiology}, \bold{118},
124--131.
}
\author{
Bernardo Sousa-Pinto \email{bernardo@med.up.pt},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
