% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure_transformToBinary.R
\name{figure_transformToBinary}
\alias{figure_transformToBinary}
\title{Transforms figure to binary image.}
\usage{
figure_transformToBinary(
  aFigure,
  threshold = 0.6,
  point_fill = FALSE,
  point_tolerance = 2
)
}
\arguments{
\item{aFigure}{The original figure image (an \code{EBImage} object).}

\item{threshold}{A proportion from zero to one designating the gray-scale
threshold to convert pixels into black or white.  Pixel intensities below
the proportion will be converted to black, and those above white.  Helps
remove noise and increase contrast among candidate objects to detect.}

\item{point_fill}{If \code{TRUE} then fills empty points/symbols in figure.}

\item{point_tolerance}{An integer used to designate the size of the points 
to fill.  Increase value to better fill empty points.}
}
\value{
An \code{EBImage} black and white object ready for object detection.
}
\description{
Transforms a figure into a black and white image.  This pre-processing of the
image is necessary to help identify objects within the figure (e.g., axes, 
plotted points).
}
