% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{subtaxa_apply}
\alias{subtaxa_apply}
\title{Apply function to subtaxa of each taxon}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object containing taxon
information to be queried.}

\item{func}{(`function`) The function to apply.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to use.
Default: All taxa in `obj` will be used. Any variable name that appears in
[all_names()] can be used as if it was a vector on its own.}

\item{recursive}{(`logical` or `numeric`) If `FALSE`, only return the
subtaxa one rank below the target taxa. If `TRUE`, return all the
subtaxa of every subtaxa, etc. Positive numbers indicate the number of
recursions (i.e. number of ranks below the target taxon to return). `1` is
equivalent to `FALSE`. Negative numbers are equivalent to `TRUE`.}

\item{simplify}{(`logical`) If `TRUE`, then combine all the results into a
single vector of unique values.}

\item{include_input}{(`logical`) If `TRUE`, the input taxa are included in
the output}

\item{value}{What data to give to the function. Any result of
`all_names(obj)` can be used, but it usually only makes sense to use data
that has an associated taxon id.}

\item{...}{Extra arguments are passed to the function.}
}
\description{
Apply a function to the subtaxa for each taxon. This is similar
to using [subtaxa()] with [lapply()] or [sapply()].
\preformatted{
obj$subtaxa_apply(func, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = "taxon_indexes", ...)
subtaxa_apply(obj, func, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = "taxon_indexes", ...)}
}
\examples{
# Count number of subtaxa in each taxon
subtaxa_apply(ex_taxmap, length)

# Paste all the subtaxon names for each taxon
subtaxa_apply(ex_taxmap, value = "taxon_names",
              recursive = FALSE, paste0, collapse = ", ")
}
