% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{names_used}
\alias{names_used}
\title{Get names of data used in expressions}
\arguments{
\item{obj}{a [taxonomy()] or [taxmap()] object}

\item{...}{One or more expressions}
}
\value{
Named `character`
}
\description{
Get names of available data used in expressions. This is used to find data
for use with [non-standard evaluation](http://adv-r.had.co.nz/Computing-on-the-language.html) (NSE) in
functions like [filter_taxa()]. Expressions are not evaluated and do not need
to make sense.
\preformatted{
obj$names_used(...)}
}
\examples{
ex_taxmap$names_used(n_legs + dangerous == invalid_expression)

}
\seealso{
Other NSE helpers: 
\code{\link{all_names}()},
\code{\link{data_used}},
\code{\link{get_data}()}
}
\concept{NSE helpers}
\keyword{internal}
