% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_ubiome}
\alias{parse_ubiome}
\title{Converts the uBiome file format to taxmap}
\usage{
parse_ubiome(file = NULL, table = NULL)
}
\arguments{
\item{file}{(\code{character} of length 1) The file path to the input file. 
Either "file", or "table" must be used, but only one.}

\item{table}{(\code{character} of length 1) An already parsed data.frame or
tibble. Either "file", or "table" must be used, but only one.}
}
\value{
\code{\link{taxmap}}
}
\description{
Converts the uBiome file format to taxmap. NOTE: This is experimental and might not work if
uBiome changes their format. Contact the maintainers if you encounter problems/
}
\details{
The input file has a format like:

\preformatted{
 tax_name,tax_rank,count,count_norm,taxon,parent
 root,root,29393,1011911,1,
 Bacteria,superkingdom,29047,1000000,2,131567
 Campylobacter,genus,23,791,194,72294
 Flavobacterium,genus,264,9088,237,49546
}
}
\seealso{
Other parsers: 
\code{\link{parse_dada2}()},
\code{\link{parse_edge_list}()},
\code{\link{parse_greengenes}()},
\code{\link{parse_mothur_tax_summary}()},
\code{\link{parse_mothur_taxonomy}()},
\code{\link{parse_newick}()},
\code{\link{parse_phyloseq}()},
\code{\link{parse_phylo}()},
\code{\link{parse_qiime_biom}()},
\code{\link{parse_rdp}()},
\code{\link{parse_silva_fasta}()},
\code{\link{parse_unite_general}()}
}
\concept{parsers}
