% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_rdp}
\alias{parse_rdp}
\title{Parse RDP FASTA release}
\usage{
parse_rdp(input = NULL, file = NULL, include_seqs = TRUE, add_species = FALSE)
}
\arguments{
\item{input}{(\code{character}) One of the following: 
\describe{
  \item{A character vector of sequences}{See the example below for what this
  looks like. The parser \code{\link{read_fasta}} produces output like this.}
  \item{A list of character vectors}{Each vector should have one base per element.}
  \item{A "DNAbin" object}{This is the result of parsers like
  \code{\link[ape]{read.FASTA}}.}
  \item{A list of "SeqFastadna" objects}{This is the result of parsers like
  \code{\link[seqinr]{read.fasta}}.}
  Either "input" or "file" must be supplied but not both.
}}

\item{file}{The path to a FASTA file containing sequences to use. Either
"input" or "file" must be supplied but not both.}

\item{include_seqs}{(\code{logical} of length 1) If \code{TRUE}, include 
sequences in the output object.}

\item{add_species}{(\code{logical} of length 1) If \code{TRUE}, add the
species information to the taxonomy. In this database, the species name
often contains other information as well.}
}
\value{
\code{\link{taxmap}}
}
\description{
Parses an RDP reference FASTA file.
}
\details{
The input file has a format like:

\preformatted{
>S000448483 Sparassis crispa; MBUH-PIRJO&ILKKA94-1587/ss5	Lineage=Root;rootrank;Fun...
ggattcccctagtaactgcgagtgaagcgggaagagctcaaatttaaaatctggcggcgtcctcgtcgtccgagttgtaa
tctggagaagcgacatccgcgctggaccgtgtacaagtctcttggaaaagagcgtcgtagagggtgacaatcccgtcttt
...
}
}
\seealso{
Other parsers: 
\code{\link{parse_dada2}()},
\code{\link{parse_edge_list}()},
\code{\link{parse_greengenes}()},
\code{\link{parse_mothur_tax_summary}()},
\code{\link{parse_mothur_taxonomy}()},
\code{\link{parse_newick}()},
\code{\link{parse_phyloseq}()},
\code{\link{parse_phylo}()},
\code{\link{parse_qiime_biom}()},
\code{\link{parse_silva_fasta}()},
\code{\link{parse_ubiome}()},
\code{\link{parse_unite_general}()}
}
\concept{parsers}
