% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writers.R
\name{make_dada2_asv_table}
\alias{make_dada2_asv_table}
\title{Make a imitation of the dada2 ASV abundance matrix}
\usage{
make_dada2_asv_table(obj, asv_table = "asv_table", asv_id = "asv_id")
}
\arguments{
\item{obj}{A taxmap object}

\item{asv_table}{The name of the abundance matrix in the taxmap object to use.}

\item{asv_id}{The name of the column in \code{asv_table} with unique ASV ids or sequences.}
}
\value{
A numeric \code{matrix} with rows as samples and columns as ASVs
}
\description{
Attempts to save the abundance matrix stored as a table in a taxmap object in the
dada2 ASV abundance matrix format. If the taxmap object was created using
\code{\link{parse_dada2}}, then it should be able to replicate the format
exactly with the default settings.
}
\seealso{
Other writers: 
\code{\link{make_dada2_tax_table}()},
\code{\link{write_greengenes}()},
\code{\link{write_mothur_taxonomy}()},
\code{\link{write_rdp}()},
\code{\link{write_silva_fasta}()},
\code{\link{write_unite_general}()}
}
\concept{writers}
