% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{counts_to_presence}
\alias{counts_to_presence}
\title{Apply a function to groups of columns}
\usage{
counts_to_presence(obj, data, threshold = 0, groups = NULL,
  cols = NULL, other_cols = FALSE, out_names = NULL,
  dataset = NULL)
}
\arguments{
\item{obj}{A \code{\link[taxa]{taxmap}} object}

\item{data}{The name of a table in \code{obj$data}.}

\item{threshold}{The value a number must be greater than to count as present.
By, default, anything above 0 is considered present.}

\item{groups}{Group multiple columns per treatment/group. This should be a
vector of group IDs (e.g. character, integer) the same length as
\code{cols} that defines which samples go in which group. When used, there
will be one column in the output for each unique value in \code{groups}.}

\item{cols}{The columns in \code{data} to use. By
default, all numeric columns are used. Takes one of the following inputs:
\describe{
\item{TRUE/FALSE:}{All/No columns will used.}
\item{Character vector:}{The names of columns to use} \item{Numeric vector:}{The indexes of
columns to use}
\item{Vector of TRUE/FALSE of length equal to the number of columns:}{Use the columns corresponding to \code{TRUE} values.} }}

\item{other_cols}{Preserve in the output non-target columns present in the
input data. New columns will always be on the end. The "taxon_id" column
will be preserved in the front. Takes one of the following inputs:
\describe{
\item{NULL:}{No columns will be added back, not even the taxon id column.}
\item{TRUE/FALSE:}{All/None of the non-target columns will be preserved.}
\item{Character vector:}{The names of columns to preserve}
\item{Numeric vector:}{The indexes of columns to preserve}
\item{Vector of TRUE/FALSE of length equal to the number of columns:}{Preserve the columns corresponding to \code{TRUE} values.}}}

\item{out_names}{The names of count columns in the output. Must be the same
length and order as \code{cols} (or \code{unique(groups)}, if \code{groups} is used).}

\item{dataset}{DEPRECIATED. use "data" instead.}
}
\value{
A tibble
}
\description{
For a given table in a \code{\link[taxa]{taxmap}} object, apply a function to
rows in groups of columns. The result of the function is used to create new
columns. This is equivalent to splitting columns of a table by a factor and
using \code{apply} on each group.
}
\examples{
\dontrun{
# Parse data for examples
x = parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                   class_key = c(tax_rank = "taxon_rank", tax_name = "taxon_name"),
                   class_regex = "^(.+)__(.+)$")

# Convert count to presence/absence
counts_to_presence(x, "tax_data")

# Check if there are any reads in each group of samples
counts_to_presence(x, "tax_data", groups = hmp_samples$body_site)

}
}
\seealso{
Other calculations: \code{\link{calc_group_mean}},
  \code{\link{calc_group_median}},
  \code{\link{calc_group_rsd}},
  \code{\link{calc_group_stat}},
  \code{\link{calc_n_samples}},
  \code{\link{calc_obs_props}},
  \code{\link{calc_prop_samples}},
  \code{\link{calc_taxon_abund}},
  \code{\link{compare_groups}}, \code{\link{rarefy_obs}},
  \code{\link{zero_low_counts}}
}
\concept{calculations}
