% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy_ranks}
\alias{taxonomy_ranks}
\title{Get ordered ranks from taxonomy}
\usage{
taxonomy_ranks(taxa, parents, rank, strict = TRUE)
}
\arguments{
\item{taxa}{(\code{character}) Unique taxon IDs for every possible taxon.}

\item{parents}{(\code{character}) Unique taxon IDs for the supertaxa of every possible taxon.
Root taxa should have \code{NA} in this column.}

\item{rank}{(\code{character}) The rank designation (e.g. "genus") corresponding to each observation in
\code{taxa}.}

\item{strict}{If \code{FALSE}, ranks with inconsistent levels will be allowed. Otherwise ranks 
with overlapping level ranges will cause an error.}
}
\description{
Returns an ordered factor of the ranks of a given taxonomy.
It also checks if rank corresponds consistently with level.
}
\keyword{internal}
