% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_pcr.R
\name{primersearch}
\alias{primersearch}
\alias{primersearch.character}
\alias{primersearch.taxmap}
\title{Use EMBOSS primersearch for in silico PCR}
\usage{
primersearch(input, forward, reverse, mismatch = 5, ...)

\method{primersearch}{character}(input, forward, reverse, mismatch = 5, ...)

\method{primersearch}{taxmap}(input, forward, reverse, mismatch = 5,
  sequence_col = "sequence", result_cols = NULL, ...)
}
\arguments{
\item{input}{(\code{character})}

\item{forward}{(\code{character} of length 1) The forward primer sequence}

\item{reverse}{(\code{character} of length 1) The reverse primer sequence}

\item{mismatch}{An integer vector of length 1. The percentage of mismatches allowed.}

\item{...}{Unused.}

\item{sequence_col}{(\code{character} of length 1) The name of the column in \code{obs_data} that has the input sequences.}

\item{result_cols}{(\code{character}) The names of columns to include in the output.
By default, all output columns are included.}
}
\value{
An object of type \code{\link{taxmap}}
}
\description{
A pair of primers are aligned against a set of sequences.
The location of the best hits, quality of match, and predicted amplicons are returned.
Requires the EMBOSS tool kit (\url{http://emboss.sourceforge.net/}) to be installed.
}
\section{Installing EMBOSS}{


The command-line tool "primersearch" from the EMBOSS tool kit is needed to use this function.
How you install EMBOSS will depend on your operating system:

\strong{Linux:}

Open up a terminal and type:

\code{sudo apt-get install emboss}

\strong{Mac OSX:}

The easiest way to install EMBOSS on OSX is to use \href{http://brew.sh/}{homebrew}.
After installing homebrew, open up a terminal and type:

\code{brew install homebrew/science/emboss}

NOTE: This has not been tested by us yet.

\strong{Windows:}

There is an installer for Windows here:

ftp://emboss.open-bio.org/pub/EMBOSS/windows/mEMBOSS-6.5.0.0-setup.exe

NOTE: This has not been tested by us yet.
}

\examples{
\dontrun{
result <- primersearch(rdp_ex_data, 
                       forward = c("U519F" = "CAGYMGCCRCGGKAAHACC"),
                       reverse = c("Arch806R" = "GGACTACNSGGGTMTCTAAT"),
                       mismatch = 10)
                       
heat_tree(result, 
          node_size = n_obs,
          node_label = name,
          node_color = prop_amplified,
          node_color_range = c("red", "yellow", "green"),
          node_color_trans = "linear",
          node_color_interval = c(0, 1),
          layout = "fruchterman-reingold")
}

}
