% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_tree--layouts.R
\name{layout_functions}
\alias{layout_functions}
\title{Layout functions}
\usage{
layout_functions(name = NULL, graph = NULL, intitial_coords = NULL,
  effort = 1, ...)
}
\arguments{
\item{name}{(\code{character} of length 1 OR NULL) name of algorithm. Leave \code{NULL} to 
see all options.}

\item{graph}{(\code{igraph}) The graph to generate the layout for.}

\item{intitial_coords}{(\code{matrix}) Initial node layout to bawse new layout off of.}

\item{effort}{(\code{numeric} of length 1) The amount of effort to put into layouts. Typically
determines the the number of iterations.}

\item{...}{(other arguments) Passed to igraph layout function used.}
}
\value{
The name available functions, a layout functions,
or a two-column matrix depending on how arguments are provided.
}
\description{
Functions used to determine graph layout.
Calling the function with no parameters returns available function names.
Calling the function with only the name of a function returns that function.
Supplying a name and a \code{\link[igraph]{graph}} object to run the layout function on the graph.
}
\examples{
# List available function names:
layout_functions()

# Execute layout function on graph:
layout_functions("davidson-harel", igraph::make_ring(5))

}

