% Generated by roxygen2 (4.0.1): do not edit by hand
\name{parallel.temper}
\alias{parallel.temper}
\alias{parallel.temper.explicit}
\title{Parallel Tempering MCMC}
\usage{
parallel.temper(step2, readSupport = 10, noChains = 12, seed = 1)

parallel.temper.explicit(readSupport = 10, noChains = 12, pij.sparse.mat,
  read.weights, ordered.species, gen.prob.unknown, outDir, seed = 1)
}
\arguments{
\item{readSupport}{The number of reads the user requires in order to believe in the presence of the species. It is used to compute the penalty factor. The default value is 10. We compute the logarithmic penalty value as the log-likelihood difference between two models: one where all N reads belong to the "unknown"  category and one where r reads have a perfect match to some unspecified species and the remaining reads belong to the "unknown"  category.}

\item{noChains}{The number of parallel chains to run. The default value is 12.}

\item{seed}{Optional argument that sets the random seed (default is 1) to make results reproducible.}

\item{step2}{list. The output from reduce.space(). Alternatively, it can be a character string containing the path name of the ".RData" file  where step2 list was saved.}

\item{pij.sparse.mat}{sparse matrix of generative probabilities, see value of ?reduce.space.}

\item{read.weights}{see ?reduce.space.}

\item{ordered.species}{see ?reduce.space.}

\item{gen.prob.unknown}{see ?reduce.space.}

\item{outDir}{see ?reduce.space.}
}
\value{
step3: A list with two elements. The first one (result) is a list that records MCMC information from each parallel chain.  The second one (duration) records how much time the MCMC exploration took.
}
\description{
Parallel Tempering MCMC

Performs Parallel Tempering MCMC to explore the species state space. Two types of moves are implemented: a mutation step (within chain) and an exchange step (between neighboring chains).  If working with BLASTn data, use parallel.temper.nucl().

parallel.temper.explicit is the same function as parallel.temper but with a more involved syntax.
}
\examples{
## See vignette for more details

\dontrun{
# Either load the object created by previous step (i.e from function reduce.space() )
data(step2)   ## example output of reduce.space
step3<-parallel.temper(step2=step2)

# or alternatively point to the location of the step2.RData object
step3 <- parallel.temper(step2="/pathtoFile/step2.RData")
}
}
\seealso{
\code{\link{parallel.temper.nucl}} This function should be used when working with BLASTn data.
}
\keyword{parallel.temper}
\keyword{parallel.temper.explicit}

