% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_USER.R
\name{es_from_user_adj}
\alias{es_from_user_adj}
\title{Directly input an adjusted value + variance of an effect size measure}
\usage{
es_from_user_adj(
  measure,
  user_es_measure_adj,
  user_es_adj,
  user_se_adj,
  user_ci_lo_adj,
  user_ci_up_adj,
  max_asymmetry = 10
)
}
\arguments{
\item{measure}{the effect size measure used in calculations (must be one of the 11 effect size measures available in metaConvert)}

\item{user_es_measure_adj}{the name of the effect size measure that will appear when this function is called by the \link{convert_df} function (can be any character string)}

\item{user_es_adj}{adjusted effect size value}

\item{user_se_adj}{adjusted standard error of the effect size}

\item{user_ci_lo_adj}{adjusted lower bound of the 95\% CI around the effect size value}

\item{user_ci_up_adj}{adjusted upper bound of the 95\% CI around the effect size value}

\item{max_asymmetry}{A percentage indicating the tolerance before detecting asymmetry in the 95\% CI bounds.}
}
\value{
This function allows to directly input any of the 11 effect size measures

\tabular{ll}{
\code{natural effect size measure} \tab Any of the 11 available measures\cr
\tab \cr
\code{converted effect size measure} \tab No conversion performed\cr
\tab \cr
\code{required input data} \tab See 'Section 24. User's input (adjusted)'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Directly input an adjusted value + variance of an effect size measure
}
\details{
This function is a generic function allowing to include any adjusted effect size measure value + variance.
Importantly, with this function, no conversions are performed (i.e., the effect size value + variance
you enter is the value + variance exported by this function).
}
\examples{
dat = data.frame(measure = "OR", user_es_measure_adj = "adjusted OR",
                 user_es_adj = -0.04, user_se_adj = 0.2)
summary(convert_df(dat, measure="logor"))
}
