% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANOVA_means.R
\name{es_from_means_se}
\alias{es_from_means_se}
\title{Convert means and standard errors of two independent groups several effect size measures}
\usage{
es_from_means_se(
  mean_exp,
  mean_se_exp,
  mean_nexp,
  mean_se_nexp,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_means
)
}
\arguments{
\item{mean_exp}{mean of participants in the experimental/exposed group.}

\item{mean_se_exp}{standard error of participants in the experimental/exposed group.}

\item{mean_nexp}{mean of participants in the non-experimental/non-exposed group.}

\item{mean_se_nexp}{standard error of participants in the non-experimental/non-exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_means}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 9. Means and dispersion (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert means and standard errors of two independent groups several effect size measures
}
\details{
This function converts the standard errors of two independent groups into standard deviations,
and then relies on the calculations of the \code{\link{es_from_means_sd}()} function.

\strong{To convert the standard errors into standard deviations}, the following formula is used.
\deqn{mean\_sd\_exp = mean\_se\_exp * \sqrt{n\_exp}}
\deqn{mean\_sd\_nexp = mean\_se\_nexp * \sqrt{n\_nexp}}
Then, calculations of the \code{\link{es_from_means_sd}()} are applied.

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_means_se(
  mean_exp = 42, mean_se_exp = 11,
  mean_nexp = 42, mean_se_nexp = 15,
  n_exp = 43, n_nexp = 34
)
}
\references{
Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
