% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_fixed.R
\name{meta_fixed}
\alias{meta_fixed}
\title{Bayesian Fixed-Effects Meta-Analysis}
\usage{
meta_fixed(
  y,
  SE,
  labels,
  data,
  d = prior("norm", c(mean = 0, sd = 0.3)),
  rscale_contin = 1/2,
  rscale_discrete = sqrt(2)/2,
  centering = TRUE,
  logml = "integrate",
  summarize = "integrate",
  ci = 0.95,
  rel.tol = .Machine$double.eps^0.3,
  silent_stan = TRUE,
  ...
)
}
\arguments{
\item{y}{effect size per study. Can be provided as (1) a numeric vector, (2)
the quoted or unquoted name of the variable in \code{data}, or (3) a
\code{\link[stats]{formula}} to include discrete or continuous moderator
variables.}

\item{SE}{standard error of effect size for each study. Can be a numeric
vector or the quoted or unquoted name of the variable in \code{data}}

\item{labels}{optional: character values with study labels. Can be a
character vector or the quoted or unquoted name of the variable in
\code{data}}

\item{data}{data frame containing the variables for effect size \code{y},
standard error \code{SE}, \code{labels}, and moderators per study.}

\item{d}{\code{prior} distribution on the average effect size \code{d}. The
prior probability density function is defined via \code{\link{prior}}.}

\item{rscale_contin}{scale parameter of the JZS prior for the continuous
covariates.}

\item{rscale_discrete}{scale parameter of the JZS prior for discrete
moderators.}

\item{centering}{whether continuous moderators are centered.}

\item{logml}{how to estimate the log-marginal likelihood: either by numerical
integration (\code{"integrate"}) or by bridge sampling using MCMC/Stan
samples (\code{"stan"}). To obtain high precision with \code{logml="stan"},
many MCMC samples are required (e.g., \code{logml_iter=10000, warmup=1000}).}

\item{summarize}{how to estimate parameter summaries (mean, median, SD,
etc.): Either by numerical integration (\code{summarize = "integrate"}) or
based on MCMC/Stan samples (\code{summarize = "stan"}).}

\item{ci}{probability for the credibility/highest-density intervals.}

\item{rel.tol}{relative tolerance used for numerical integration using
\code{\link[stats]{integrate}}. Use \code{rel.tol=.Machine$double.eps} for
maximal precision (however, this might be slow).}

\item{silent_stan}{whether to suppress the Stan progress bar.}

\item{...}{further arguments passed to \code{rstan::sampling} (see
\code{\link[rstan]{stanmodel-method-sampling}}). Relevant MCMC settings
concern the number of warmup samples that are discarded
(\code{warmup=500}), the total number of iterations per chain
(\code{iter=2000}), the number of MCMC chains (\code{chains=4}), whether
multiple cores should be used (\code{cores=4}), and control arguments that
make the sampling in Stan more robust, for instance:
\code{control=list(adapt_delta=.97)}.}
}
\description{
Runs a Bayesian meta-analysis assuming that the mean effect \eqn{d} in each
study is identical (i.e., a fixed-effects analysis).
}
\examples{
data(towels)
### Bayesian Fixed-Effects Meta-Analysis (H1: d>0 Cauchy)
mf <- meta_fixed(logOR, SE, study, data = towels,
                 d = prior("norm", c(mean=0, sd=.3), lower=0))
mf
plot_posterior(mf)
plot_forest(mf)
}
