% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnt.R
\name{nnt}
\alias{nnt}
\alias{nnt.default}
\alias{nnt.meta}
\alias{print.nnt.meta}
\title{Calculate the number needed to treat (NNT)}
\usage{
nnt(x, ...)

\method{nnt}{meta}(x, p.c, fixed = x$fixed, random = x$random, ...)

\method{nnt}{default}(x, p.c, sm, lower, upper, ...)

\method{print}{nnt.meta}(
  x,
  fixed = x$fixed,
  random = x$random,
  digits = gs("digits"),
  digits.prop = gs("digits.prop"),
  big.mark = gs("big.mark"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta}, or estimated treatment
effect, i.e., risk difference(s), risk ratio(s), or odds ratio(s).}

\item{\dots}{Additional arguments (ignored at the moment).}

\item{p.c}{Baseline risk (control group event probability).}

\item{fixed}{A logical indicating whether NNTs should be
calculated based on fixed effect estimate.}

\item{random}{A logical indicating whether NNTs should be
calculated based on random effects estimate.}

\item{sm}{Summary measure.}

\item{lower}{Lower confidence interval limit.}

\item{upper}{Upper confidence interval limit.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.prop}{Minimal number of significant digits for
proportions, see \code{print.default}.}

\item{big.mark}{A character used as thousands separator.}
}
\description{
Calculate the number needed to treat (NNT) from estimated risk
difference, risk ratio, or odds ratio, and a baseline risk.
}
\details{
The number needed to treat (NNT) can be easily computed from an
estimated risk difference (RD), risk ratio (RR), or odds ratio (OR)
and a given baseline risk (Higgins & Green, 2011, section 12.5).

Accordlingly, this function can be used to calculate NNTs for
meta-analyses generated with \code{\link{metabin}} or
\code{\link{metagen}} if argument \code{sm} was equal to
\code{"RD"}, \code{"RR"}, or \code{"OR"}. It is also possible to
directly provide estimated treatment effects without conducting a
meta-analysis (see Examples).

The baseline risk can be specified using argument \code{p.c}. If
this argument is missing, the minimum, mean, and maximum of the
control event probabilities in the meta-analysis are used for
\code{\link{metabin}}; otherwise the control event probabilities
0.1, 0.2, \dots, 0.9 are used.
}
\examples{
# Calculate NNT for RD = -0.21
# (Cochrane Handbook, version 5.1, subsection 12.5.4.1)
nnt(-0.21, sm = "RD")

# Calculate NNT for RR = 0.92 and baseline risk p.c = 0.3
# (Cochrane Handbook, version 5.1, subsection 12.5.4.2)
nnt(0.92, p.c = 0.3, sm = "RR")

# Calculate NNT for OR = 0.73 and baseline risk p.c = 0.3
# (Cochrane Handbook, version 5.1, subsection 12.5.4.3)
nnt(0.73, p.c = 0.3, sm = "OR")

# Use Mantel-Haenszel odds ratio to calculate NNTs
data(Olkin1995)
m1 <- metabin(ev.exp, n.exp, ev.cont, n.cont, data = Olkin1995,
              random = FALSE)
nnt(m1, random = TRUE)

}
\references{
Higgins, J.P.T and S. Green (2011):
\emph{Cochrane Handbook for Systematic Reviews of Interventions
  Version 5.1.0 [Updated March 2011]}.
The Cochrane Library: http://www.cochrane-handbook.org
}
\seealso{
\code{\link{metabin}}, \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
