% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.meta.R
\name{summary.meta}
\alias{summary.meta}
\title{Summary of meta-analysis results}
\usage{
\method{summary}{meta}(object, ...)
}
\arguments{
\item{object}{An object of class \code{meta}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An object of classes \code{summary.meta} and \code{meta}.
}
\description{
Summary method for objects of class \code{meta}.
}
\details{
Review Manager 5 (RevMan 5) is the current software used for
preparing and maintaining Cochrane Reviews
(\url{https://training.cochrane.org/online-learning/core-software-cochrane-reviews/revman}).
In RevMan 5, subgroup analyses can be defined and data from a
Cochrane review can be imported to Rusing the function
\code{read.rm5}. If a meta-analysis is then conducted using
function \code{metacr}, information on subgroups is available in R
(components \code{subgroup}, \code{subgroup.name}, and
\code{print.subgroup.name}, \code{subgroup} in an object of class
\code{"meta"}).  Accordingly, by using function \code{metacr} there
is no need to define subgroups in order to redo the statistical
analysis conducted in the Cochrane review.

Note, for an object of type \code{metaprop}, starting with version
3.7-0 of meta, list elements \code{TE}, \code{lower} and
\code{upper} in element \code{study} correspond to transformed
proportions and confidence limits (regardless whether exact
confidence limits are calculated; argument \code{ciexact=TRUE} in
metaprop function). Accordingly, the following results are based on
the same transformation defined by argument \code{sm}: list
elements \code{TE}, \code{lower} and \code{upper} in elements
\code{study}, \code{fixed}, \code{random}, \code{within.fixed} and
\code{within.random}.

R function cilayout can be utilised to change the layout to print
confidence intervals (both in printout from print.meta and
print.summary.meta function as well as in forest plots). The
default layout is "[lower; upper]". Another popular layout is
"(lower - upper)" which is used throughout an R session by using R
command \code{cilayout("(", " - ")}.

Argument \code{pscale} can be used to rescale single proportions or
risk differences, e.g. \code{pscale=1000} means that proportions
are expressed as events per 1000 observations. This is useful in
situations with (very) low event probabilities.

Argument \code{irscale} can be used to rescale single rates or rate
differences, e.g. \code{irscale=1000} means that rates are
expressed as events per 1000 time units, e.g. person-years. This is
useful in situations with (very) low rates. Argument \code{irunit}
can be used to specify the time unit used in individual studies
(default: "person-years"). This information is printed in summaries
and forest plots if argument \code{irscale} is not equal to 1.
}
\examples{
data(Fleiss1993cont)
m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
               data = Fleiss1993cont, sm = "SMD",
               studlab = paste(study, year))
summary(m1)

summary(update(m1, subgroup = c(1, 2, 1, 1, 2), subgroup.name = "group"))
forest(update(m1, subgroup = c(1, 2, 1, 1, 2), subgroup.name = "group"))

\dontrun{
# Use unicode characters to print tau^2, tau, and I^2
print(summary(m1),
      text.tau2 = "\u03c4\u00b2", text.tau = "\u03c4", text.I2 = "I\u00b2")
}

}
\references{
Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation

Crippa A, Khudyakov P, Wang M, Orsini N, Spiegelman D (2016):
A new measure of between-studies heterogeneity in meta-analysis.
\emph{Statistics in Medicine},
\bold{35}, 3661--75

Higgins JPT & Thompson SG (2002):
Quantifying heterogeneity in a meta-analysis.
\emph{Statistics in Medicine},
\bold{21}, 1539--58
}
\seealso{
\code{\link{print.summary.meta}}, \code{\link{metabin}},
  \code{\link{metacont}}, \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
