% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radial.R
\name{radial.meta}
\alias{radial.meta}
\alias{radial}
\alias{radial.default}
\title{Radial plot}
\usage{
\method{radial}{meta}(
  x,
  xlim = NULL,
  ylim = NULL,
  xlab = "Inverse of standard error",
  ylab = "Standardised treatment effect (z-score)",
  fixed = TRUE,
  axes = TRUE,
  pch = 1,
  text = NULL,
  cex = 1,
  col = NULL,
  level = NULL,
  ...
)

\method{radial}{default}(
  x,
  y,
  xlim = NULL,
  ylim = NULL,
  xlab = "Inverse of standard error",
  ylab = "Standardised treatment effect (z-score)",
  fixed = TRUE,
  axes = TRUE,
  pch = 1,
  text = NULL,
  cex = 1,
  col = NULL,
  level = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{meta}, or estimated treatment
effect in individual studies.}

\item{xlim}{The x limits (min, max) of the plot.}

\item{ylim}{The y limits (min, max) of the plot.}

\item{xlab}{A label for the x-axis.}

\item{ylab}{A label for the y-axis.}

\item{fixed}{A logical indicating whether the pooled fixed
effect estimate should be plotted.}

\item{axes}{A logical indicating whether axes should be drawn on
the plot.}

\item{pch}{The plotting symbol used for individual studies.}

\item{text}{A character vector specifying the text to be used
instead of plotting symbol.}

\item{cex}{The magnification to be used for plotting symbol.}

\item{col}{A vector with colour of plotting symbols.}

\item{level}{The confidence level utilised in the plot.}

\item{\dots}{Graphical arguments as in \code{par} may also be
passed as arguments.}

\item{y}{Standard error of estimated treatment effect.}
}
\description{
Draw a radial plot (also called Galbraith plot) which can be used
to assess bias in meta-analysis.
}
\details{
A radial plot (Galbraith 1988a,b), also called Galbraith plot, is
drawn in the active graphics window. If \code{fixed} is TRUE,
the pooled estimate of the fixed effect model is plotted. If
\code{level} is not NULL, the corresponding confidence limits are
drawn.
}
\examples{
data(Olkin1995)
m1 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
              data = Olkin1995, subset = c(41, 47, 51, 59),
              studlab = paste(author, year),
              sm = "RR", method = "I")

# Radial plot
#
radial(m1, level = 0.95)

}
\references{
Galbraith RF (1988a):
Graphical display of estimates having differing standard errors.
\emph{Technometrics},
\bold{30}, 271--81

Galbraith RF (1988b):
A note on graphical presentation of estimated odds ratios from
several clinical trials.
\emph{Statistics in Medicine},
\bold{7}, 889--94
}
\seealso{
\code{\link{metabias}}, \code{\link{metabin}},
  \code{\link{metagen}}, \code{\link{funnel}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{hplot}
