% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfcorrect.R
\name{selfcorrect}
\alias{selfcorrect}
\title{Self correct the code returned by the agent}
\usage{
selfcorrect(
  agent,
  prompt,
  context = rbionfoExp,
  attempts = 3,
  output.file = NULL,
  ...
)
}
\arguments{
\item{agent}{An object containing the agent's information (e.g., type and model).}

\item{prompt}{The prompt text to send to the language model.}

\item{context}{Optional context to provide alongside the prompt (default is rbionfoExp).}

\item{attempts}{Numeric value denoting how many times the code should be sent back for fixing.}

\item{output.file}{Optional output file created holding parsed code}

\item{...}{Additional arguments to be passed to the \code{\link{sendPrompt}} function.}
}
\value{
A list containing the following elements:
\item{init.response}{A character vector representing the initial prompt response.}
\item{init.blocks}{A list of initial blocks.}
\item{final.blocks}{A list of final blocks.}
\item{code.works}{A boolean value indicating whether the code works.}
\item{exec.result}{A character string representing the execution results.}
\item{tried.attempts}{An integer representing the number of attempts.}
}
\description{
The function attempts to correct the code returned by the agent
by re-feeding to the agent with the error message. If there are no
error messages function returns the original response.
}
\examples{
\dontrun{

response <- selfcorrect(agent,prompt,context=rbionfoExp, max_tokens = 500)
}
}
\seealso{
\code{\link{promptContext}} for predefined contexts to use.
}
