#' function to extract critical values. For internal use only.
#' @keywords internal

##############################################################################################################################
##############################################################################################################################
###################### Sup-Wald fixed-b test by Iacone, Leybourne, Taylor (2014) #############################################
##############################################################################################################################
##############################################################################################################################
d_vec                   <- c(-0.49,seq(-0.4,0.4,0.1),0.49)
A                       <- matrix(c(3.31,3.77,4.51,5.67, 7.17, 9.42,12.46,16.76,22.64,30.66,39.21,
                                    5.33,5.94,6.88,8.18, 9.84,11.96,14.86,18.51,23.51,29.19,35.56,
                                    7.87,8.85,10.39,12.33,14.82,17.84,21.54,26.25,31.86,38.48,45.26,
                                    3.82,4.40,5.34,6.74, 8.89,11.89,15.86,21.62,29.18,39.65,52.13,
                                    6.11,6.89,8.10,9.94,12.31,15.39,19.33,24.59,30.90,39.10,48.08,
                                    8.96,10.31,12.44,15.21,18.88,23.93,29.43,36.41,44.52,54.78,63.80,
                                    4.94,5.84,7.28,9.48,12.64,17.40,24.53,34.44,46.06,62.84,85.56,
                                    7.76,8.94,11.06,14.16,18.10,23.84,31.24,39.88,51.17,62.63,83.42,
                                    11.69,14.10,18.05,22.90,29.75,39.20,50.84,67.41,82.99,101.71,123.84),9,11,byrow=TRUE)

supwaldfixedb_crit      <- array(NA,c(length(d_vec),4,3))
supwaldfixedb_crit[,,1] <- cbind(d_vec,t(A[1:3,]))
supwaldfixedb_crit[,,2] <- cbind(d_vec,t(A[4:6,]))
supwaldfixedb_crit[,,3] <- cbind(d_vec,t(A[7:9,]))

dimnames(supwaldfixedb_crit)[[2]] <- c("d_vec","0.05","0.1","0.2")
dimnames(supwaldfixedb_crit)[[3]] <- c("90%", "95%", "99%")
##############################################################################################################################
##############################################################################################################################
###################### CUSUM-LM Test #########################################################################################
##############################################################################################################################
##############################################################################################################################
d_vec         <- c(-0.49,seq(-0.48,0.48,0.04),0.49)
A             <- matrix(c(0.29420302, 0.31609734, 0.35869991,
                         1.22634894, 1.31422425, 1.50084198, 1.82195775, 1.95680192, 2.22408890, 2.01917197, 2.18325227, 2.50849251,
                         2.07030128, 2.25572589, 2.57409923, 2.03876806, 2.20674176, 2.53848582, 1.96320809, 2.12682809, 2.48206793,
                         1.85407665, 2.01906706, 2.36241459, 1.73572916, 1.89495215, 2.22538739, 1.63080848, 1.78704218, 2.12116938,
                         1.50109937, 1.66107119, 1.97164289, 1.40416976, 1.55226444, 1.83816931, 1.31308944, 1.45151940, 1.72688675,
                         1.19273819, 1.33196101, 1.58961270, 1.11292105, 1.24102070, 1.53046666, 1.02700301, 1.14357632, 1.39082324,
                         0.93102529, 1.05190104, 1.29153293, 0.85457528, 0.96382573, 1.15618966, 0.77305178, 0.87335360, 1.08037777,
                         0.69335745, 0.79038863, 0.97870539, 0.61481366, 0.69431937, 0.87192998, 0.54591531, 0.62620043, 0.78258036,
                         0.46774826, 0.53464672, 0.67748101, 0.38561641, 0.44038276, 0.55114246, 0.28818303, 0.33016667, 0.40732032,
                         0.16333480, 0.18652033, 0.23712450, 0.03588512, 0.04103016, 0.05224045),27,3,byrow=TRUE)

cusumlm_crit      <- array(NA,c(length(d_vec),2,3))
cusumlm_crit[,,1] <- cbind(d_vec,A[,1])
cusumlm_crit[,,2] <- cbind(d_vec,A[,2])
cusumlm_crit[,,3] <- cbind(d_vec,A[,3])

dimnames(cusumlm_crit)[[2]] <- c("d_vec","0")
dimnames(cusumlm_crit)[[3]] <- c("90%", "95%", "99%")
##############################################################################################################################
##############################################################################################################################
###################### Wilcoxon long memory test (Dehling et al, 2012) #######################################################
##############################################################################################################################
##############################################################################################################################

A                    <- cusumlm_crit
A                    <- A[,2,]/(2*sqrt(pi))
wilcoxonLM_crit      <- array(NA,c(length(d_vec),2,3))
wilcoxonLM_crit[,,1] <- cbind(d_vec,A[,1])
wilcoxonLM_crit[,,2] <- cbind(d_vec,A[,2])
wilcoxonLM_crit[,,3] <- cbind(d_vec,A[,3])

dimnames(wilcoxonLM_crit)[[2]] <- c("d_vec","0")
dimnames(wilcoxonLM_crit)[[3]] <- c("90%", "95%", "99%")

##############################################################################################################################
##############################################################################################################################
###################### Self-normalized Wilcoxon test (Betken, 2016) ##########################################################
##############################################################################################################################
##############################################################################################################################

d_vec              <- c(0.001,0.1,0.2,0.3,0.4,0.499)
A                  <- matrix(c(5.460569,6.429106,8.518842,6.182835,7.276568,9.785915,6.847260,8.190125,11.380584,
                               7.767277,9.495194,13.021080,8.520039,10.333602,14.544094,9.388174,11.339853,15.719645),6,3,byrow=TRUE)
snwilcox_crit      <- array(NA,c(length(d_vec),2,3))
snwilcox_crit[,,1] <- cbind(d_vec,A[,1])
snwilcox_crit[,,2] <- cbind(d_vec,A[,2])
snwilcox_crit[,,3] <- cbind(d_vec,A[,3])

dimnames(snwilcox_crit)[[2]] <- c("d_vec","0")
dimnames(snwilcox_crit)[[3]] <- c("90%", "95%", "99%")


##############################################################################################################################
##############################################################################################################################
###################### Self-normalized sup-Wald test (Shao, 2011) ############################################################
##############################################################################################################################
##############################################################################################################################

d_vec               <- c(-0.499,seq(-0.48,0.48,0.04),0.499)
A                   <- matrix(c(20.05,21.92,25.18,20.13,22.15,25.90, 20.90,23.09,26.81, 21.28,23.72,28.35, 21.60,23.94,29.23,
22.43,25.07,30.48, 23.05,25.85,31.77, 23.79,26.91,33.23, 24.32,27.81,34.73,25.31,29.06,36.63,
26.08,29.94,38.13, 27.22,31.37,40.58, 28.12,32.22,41.98,28.71,33.42,43.32,29.93,34.52,45.58,
31.22,36.47,48.11,32.51,38.06,50.16,33.72,39.25,51.55,34.83,40.43,53.82,36.28,42.85,56.26,
37.18,44.05,59.46,38.11,45.34,60.13,39.84,47.18,62.52,40.58,48.17,65.38,41.86,49.65,68.32,
43.51,51.92,69.68,44.71,53.51,71.58),length(d_vec),3,byrow=TRUE)

snsupwald_crit      <- array(NA,c(length(d_vec),2,3))
snsupwald_crit[,,1] <- cbind(d_vec,A[,1])
snsupwald_crit[,,2] <- cbind(d_vec,A[,2])
snsupwald_crit[,,3] <- cbind(d_vec,A[,3])

dimnames(snsupwald_crit)[[2]] <- c("d_vec","0")
dimnames(snsupwald_crit)[[3]] <- c("90%", "95%", "99%")

##############################################################################################################################
##############################################################################################################################
###################### CUSUM type A fixed-b approach #########################################################################
##############################################################################################################################
##############################################################################################################################

d_vec                       <- c(-0.49,seq(-0.4,0.4,0.1),0.49)
A                           <- matrix(c(
  0.796,0.847,0.905,0.982,1.085,1.200,1.315,1.433,1.563,1.662,1.758,0.846,0.906,0.978,1.071,1.174,1.302,
  1.421,1.545,1.674,1.769,1.850,0.956,1.030,1.116,1.215,1.354,1.504,1.608,1.729,1.851,1.921,1.989,
  1.008,1.071,1.192,1.041,1.112,1.234,1.072,1.143,1.275,1.108,1.185,1.320,1.146,1.229,1.351,1.188,1.271,
  1.406,1.238,1.316,1.444,1.275,1.349,1.464,1.314,1.391,1.494,1.356,1.423,1.514,1.391,1.450,1.525,
  1.269,1.332,1.460,1.259,1.324,1.440,1.243,1.307,1.427,1.243,1.305,1.426,1.217,1.274,1.392,1.204,1.258,
  1.359,1.188,1.241,1.332,1.172,1.224,1.318,1.161,1.204,1.280,1.152,1.192,1.266,1.147,1.184,1.248,
  1.447,1.513,1.669,1.427,1.498,1.643,1.387,1.462,1.590,1.343,1.409,1.547,1.300,1.373,1.502,1.254,1.320,
  1.457,1.213,1.272,1.403,1.173,1.231,1.359,1.137,1.192,1.313,1.115,1.163,1.273,1.092,1.134,1.237,
  1.607,1.685,1.851,1.572,1.646,1.811,1.521,1.602,1.766,1.461,1.532,1.700,1.405,1.487,1.654,1.352,1.426,
  1.586,1.299,1.374,1.538,1.244,1.320,1.473,1.200,1.263,1.398,1.160,1.223,1.372,1.131,1.190,1.338,
  1.756,1.844,2.016,1.713,1.795,1.960,1.661,1.750,1.933,1.600,1.686,1.872,1.535,1.621,1.793,1.465,1.550,
  1.720,1.399,1.488,1.670,1.338,1.420,1.597,1.295,1.379,1.539,1.245,1.321,1.476,1.213,1.300,1.463,
  1.888,1.984,2.185,1.844,1.936,2.141,1.797,1.897,2.089,1.710,1.809,2.003,1.644,1.743,1.924,1.579,1.680,
  1.860,1.495,1.592,1.780,1.441,1.529,1.704,1.388,1.488,1.665,1.327,1.413,1.588,1.292,1.388,1.561,
  2.020,2.120,2.327,1.969,2.073,2.281,1.907,2.007,2.197,1.829,1.936,2.142,1.754,1.851,2.042,1.667,1.772,
  1.990,1.594,1.694,1.889,1.524,1.621,1.805,1.463,1.562,1.748,1.413,1.504,1.684,1.371,1.454,1.634,
  2.150,2.260,2.475,2.091,2.201,2.435,2.027,2.130,2.352,1.944,2.050,2.272,1.852,1.951,2.143,1.767,1.861,
  2.063,1.686,1.794,1.994,1.614,1.711,1.904,1.541,1.632,1.831,1.492,1.578,1.752,1.449,1.540,1.739,
  2.267,2.380,2.611,2.215,2.326,2.557,2.142,2.252,2.463,2.047,2.159,2.362,1.957,2.063,2.286,1.862,1.977,
  2.209,1.776,1.878,2.099,1.698,1.804,1.985,1.638,1.727,1.921,1.571,1.660,1.842,1.523,1.617,1.798,
  2.375,2.492,2.749,2.312,2.430,2.674,2.248,2.359,2.603,2.160,2.274,2.521,2.065,2.183,2.405,1.965,2.071,
  2.293,1.869,1.975,2.186,1.796,1.903,2.128,1.721, 1.833,2.026,1.654,1.756,1.953,1.608,1.709,1.898),33,11,byrow=FALSE)

CUSUMfixedb_typeA_crit      <- array(NA,c(11,12,3))
CUSUMfixedb_typeA_crit[,,1] <- cbind(d_vec,A[1:11,])
CUSUMfixedb_typeA_crit[,,2] <- cbind(d_vec,A[12:22,])
CUSUMfixedb_typeA_crit[,,3] <- cbind(d_vec,A[23:33,])

dimnames(CUSUMfixedb_typeA_crit)[[2]] <- c("d_vec","0.05","0.1","0.2","0.3","0.4","0.5","0.6","0.7","0.8","0.9","1")
dimnames(CUSUMfixedb_typeA_crit)[[3]] <- c("90%", "95%", "99%")

##############################################################################################################################
##############################################################################################################################
###################### CUSUM type B fixed-b approach #########################################################################
##############################################################################################################################
##############################################################################################################################

d_vec                       <- c(-0.49,seq(-0.4,0.4,0.1),0.49)
A                           <- matrix(c(
  0.8073,0.8571,0.9412,1.0527,1.1922,1.3697,1.5765,1.8620,2.1559,2.5127, 2.9066,
  0.8652,0.9230,1.0310,1.1605,1.3261,1.5364,1.8028,2.1389,2.4762,2.8978, 3.3496,
  0.9830,1.0827,1.2044,1.3688,1.6057,1.8757,2.2415,2.7143,3.2465,3.6748, 4.3471,
  1.0183,1.0738,1.1549,1.2527,1.3754,1.5468,1.7119,1.9320,2.1846,2.5178, 2.7538,
  1.0896,1.1607,1.2772,1.3826,1.5512,1.7502,1.9831,2.2468,2.5598,2.9485, 3.3267,
  1.2386,1.3334,1.4922,1.6915,1.9194,2.1841,2.5803,2.9103,3.3460,3.8957, 4.4715,
  1.2282,1.3053,1.4226,1.5543,1.6997,1.8886,2.0873,2.3216,2.6200,2.8995, 3.1462,
  1.3201,1.4189,1.5764,1.7316,1.9502,2.1837,2.4562,2.7438,3.1207,3.4639, 3.8331,
  1.5169,1.6792,1.8638,2.1208,2.4887,2.8387,3.3484,3.6013,4.2831,4.8987, 5.3667,
  1.3477,1.4490,1.6219,1.7641,1.9775,2.2004,2.4835,2.8050,3.1251,3.4872, 3.7349,
  1.4545,1.5841,1.8015,1.9854,2.2950,2.5992,2.9626,3.3115,3.7637,4.2591, 4.5475,
  1.6728,1.8950,2.1721,2.4849,2.9368,3.4443,3.9903,4.4736,5.3881,5.8940, 6.3650,
  1.4438,1.5651,1.7298,1.9755,2.2436,2.5357,2.8584,3.1801,3.5814,4.0153, 4.4119,
  1.5735,1.7304,1.9510,2.2406,2.6182,2.9886,3.3724,3.8432,4.3647,4.8645, 5.3445,
  1.8524,2.0849,2.3967,2.7968,3.3641,3.9367,4.5977,5.2688,5.9867,6.8404, 7.3332,
  1.5559,1.6970,1.8771,2.1564,2.4378,2.8516,3.2014,3.5754,4.1246,4.5492, 4.8675,
  1.7001,1.8882,2.1117,2.4785,2.8180,3.3774,3.7459,4.3259,5.0158,5.4732, 5.8419,
  2.0264,2.2824,2.6517,3.1767,3.7235,4.4812,5.0940,5.9031,6.9441,7.6175, 8.2053,
  1.6594,1.8174,2.0337,2.3233,2.6591,3.0536,3.4727,3.9235,4.4240,4.9396, 5.3636,
  1.8407,2.0156,2.3051,2.6761,3.1213,3.6238,4.1130,4.6789,5.3538,5.8784, 6.4540,
  2.2250,2.4779,2.8307,3.4242,4.0203,4.8917,5.5579,6.3260,7.4331,8.2769, 9.0206,
  1.7791,1.9278,2.1745,2.4799,2.8396,3.2298,3.7013,4.2242,4.7807,5.2695, 5.7311,
  1.9900,2.1645,2.4670,2.8893,3.3038,3.8455,4.4156,5.0848,5.6875,6.3983, 6.8664,
  2.3763,2.6752,3.1173,3.7307,4.2868,5.0078,6.0135,6.9103,7.7077,8.9216, 9.5341,
  1.8818,2.0433,2.3156,2.6282,2.9965,3.4266,3.9810,4.4273,4.9538,5.6088, 5.9400,
  2.0835,2.3083,2.6379,3.0606,3.4756,4.0641,4.7841,5.3851,6.0079,6.6763, 7.4125,
  2.4963,2.8860,3.3484,3.8967,4.4940,5.3737,6.3982,7.2338,8.4559,9.1075,10.3022,
  2.0040,2.2112,2.4287,2.7509,3.1751,3.6045,4.1021,4.6306,5.2519,5.7997, 6.2862,
  2.2576,2.5030,2.7832,3.2020,3.6912,4.2811,4.9061,5.5670,6.3475,6.9847, 7.5742,
  2.7228,3.0510,3.5146,4.0721,4.7975,5.6915,6.8767,7.4788,8.8181,9.6303,10.3625,
  2.1335,2.3232,2.6095,2.9641,3.3225,3.7861,4.3457,4.8926,5.4429,6.0591, 6.5773,
  2.3633,2.6105,2.9744,3.4065,3.8878,4.4429,5.1810,5.8524,6.5238,7.3075, 7.9557,
  2.8492,3.1892,3.7610,4.3337,5.1184,5.9440,7.1085,8.1402,9.0406,0.0137,11.3328),33,11,byrow=FALSE)

CUSUMfixedb_typeB_crit      <- array(NA,c(11,12,3))
CUSUMfixedb_typeB_crit[,,1] <- cbind(d_vec,A[1:11,])
CUSUMfixedb_typeB_crit[,,2] <- cbind(d_vec,A[12:22,])
CUSUMfixedb_typeB_crit[,,3] <- cbind(d_vec,A[23:33,])

dimnames(CUSUMfixedb_typeB_crit)[[2]] <- c("d_vec","0.05","0.1","0.2","0.3","0.4","0.5","0.6","0.7","0.8","0.9","1")
dimnames(CUSUMfixedb_typeB_crit)[[3]] <- c("90%", "95%", "99%")

##############################################################################################################################
##############################################################################################################################
###################### CUSUM type A fixed-m approach #########################################################################
##############################################################################################################################
##############################################################################################################################

d_vec                       <- c(-0.49,seq(-0.4,0.4,0.1),0.49)
A                           <- matrix(c(
  4.3859,3.7246,3.0973,2.6550,2.2939,2.0238,1.7813,1.5294,1.4366,1.2921,1.2268,
  6.2089, 5.1566,4.3652,3.7226,3.1207,2.7797,2.4534,2.0384,1.9535,1.6745,1.6002,
  14.4754,12.3285,9.9944,8.1339,7.1185,6.4786,5.3965,3.9801,4.0088,3.1962,3.4559,
  2.4567, 2.1449,1.8639,1.6229,1.4645,1.3388,1.2354,1.1587,1.1198,1.0818,1.0701,
  2.9560, 2.5703,2.2079,1.9127,1.6981,1.5208,1.3888,1.2974,1.2283,1.1770,1.1621,
  4.3651, 3.8284,3.2595,2.8151,2.3616,2.1020,1.8289,1.7378,1.6089,1.4787,1.4284,
  1.9189, 1.7268,1.5513,1.3932,1.3051,1.2360,1.1861,1.1603,1.1512,1.1498,1.1499,
  2.1963, 1.9567,1.7447,1.5630,1.4519,1.3515,1.2883,1.2532,1.2297,1.2186,1.2075,
  2.9916, 2.6325,2.2117,1.9826,1.7902,1.6489,1.5345,1.4368,1.4062,1.3614,1.3263,
  1.6387, 1.5263,1.3826,1.2984,1.2467,1.2140,1.1953,1.1947,1.2050,1.2283,1.2484,
  1.8461, 1.7054,1.5433,1.4187,1.3661,1.3183,1.2902,1.2810,1.2847,1.2954,1.3107,
  2.3560, 2.1182,1.9050,1.7171,1.6162,1.5251,1.4907,1.4316,1.4262,1.4120,1.4079,
  1.0655, 1.0398,1.0454,1.0691,1.1175,1.1881,1.2901,1.3935,1.4961,1.6051,1.7028,
  1.1633, 1.1405,1.1457,1.1718,1.2220,1.3037,1.4108,1.5172,1.6118,1.7200,1.8110,
  1.3348, 1.3391,1.3629,1.3787,1.4380,1.5193,1.6096,1.7210,1.8023,1.8880,1.9638,
  0.7147, 0.7548,0.8171,0.9069,1.0279,1.1873,1.3942,1.6410,1.9073,2.1850,2.4147,
  0.7699, 0.8175,0.8869,0.9881,1.1383,1.3184,1.5372,1.8200,2.0998,2.3836,2.5877,
  0.8842, 0.9417,1.0504,1.1730,1.3399,1.5573,1.7914,2.1073,2.4154,2.6678,2.8537,
  0.5468, 0.5981,0.6831,0.8028,0.9645,1.2052,1.5110,1.8722,2.2829,2.8013,3.1753,
  0.5857, 0.6441,0.7449,0.8815,1.0704,1.3354,1.6742,2.0957,2.5282,3.0722,3.4468,
  0.6692, 0.7361,0.8689,1.0385,1.2660,1.5866,1.9803,2.4469,2.9820,3.5045,3.8287,
  0.4231, 0.4818,0.5766,0.7129,0.9108,1.1985,1.6092,2.1311,2.7891,3.5491,4.2393,
  0.4573, 0.5213,0.6234,0.7839,1.0069,1.3335,1.7819,2.3853,3.1146,3.8828,4.6147,
  0.5253, 0.5966,0.7284,0.9126,1.2010,1.5846,2.1595,2.8229,3.6676,4.4783,5.1822,
  0.3716, 0.4301,0.5279,0.6635,0.8788,1.1903,1.6383,2.2527,3.0859,4.0696,5.0025,
  0.3987, 0.4620,0.5736,0.7275,0.9681,1.3285,1.8278,2.5216,3.4528,4.5423,5.4761,
  0.4504, 0.5296,0.6651,0.8491,1.1381,1.5885,2.2310,3.0285,4.1395,5.2907,6.1296,
  0.3346, 0.3943,0.4843,0.6330,0.8449,1.1766,1.6701,2.3666,3.2943,4.4705,5.5661,
  0.3592, 0.4235,0.5258,0.6946,0.9391,1.3105,1.8641,2.6583,3.6940,4.9674,6.1206,
  0.4095, 0.4785,0.6173,0.8123,1.1001,1.5470,2.2151,3.2486,4.4362,5.8444,6.9920),33,10,byrow=FALSE)

CUSUMfixedm_typeA_crit      <- array(NA,c(11,11,3))
CUSUMfixedm_typeA_crit[,,1] <- cbind(d_vec,A[1:11,])
CUSUMfixedm_typeA_crit[,,2] <- cbind(d_vec,A[12:22,])
CUSUMfixedm_typeA_crit[,,3] <- cbind(d_vec,A[23:33,])

dimnames(CUSUMfixedm_typeA_crit)[[2]] <- c("d_vec","1","2","3","4","10","25","50","100","150","200")
dimnames(CUSUMfixedm_typeA_crit)[[3]] <- c("90%", "95%", "99%")

##############################################################################################################################
##############################################################################################################################
###################### CUSUM type B fixed-m approach #########################################################################
##############################################################################################################################
##############################################################################################################################

d_vec                       <- c(-0.49,seq(-0.4,0.4,0.1),0.49)
A                           <- matrix(c(
  34.9837, 37.2893, 36.3915, 36.6297, 36.9138, 31.7425, 27.9493, 22.6651, 21.5772, 18.0193, 16.2797,
  53.3581, 55.4879, 57.6084, 59.5483, 61.7087, 58.5266, 55.3042, 50.2539, 44.9724, 39.2455, 31.4546,
  130.1873,136.1752,139.6792,154.7239,155.4744,147.5283,160.5702,154.6499,176.6599,160.5204,135.7577,
  2.5306,  2.5510,  2.6316,  2.7057,  2.7096,  2.8445,  2.9233,  2.9420,  3.2898,  3.3865,  3.5343,
  3.3358,  3.4569,  3.4457,  3.6515,  3.6785,  3.7391,  3.8203,  3.9101,  4.3988,  4.6234,  4.6691,
  6.4042,  6.9081,  6.5653,  6.7856,  6.8017,  7.2296,  7.1198,  6.8326,  7.5294,  8.0931,  8.4213,
  1.7701,  1.8000,  1.8065,  1.8329,  1.8826,  1.9646,  2.0728,  2.1754,  2.3834,  2.5295,  2.7567,
  2.0301,  2.1028,  2.1437,  2.2263,  2.2656,  2.4258,  2.5073,  2.6818,  2.9669,  3.1521,  3.4760,
  2.8328,  3.0354,  3.0575,  3.1835,  3.4560,  3.7331,  3.7261,  4.1224,  4.5653,  4.9249,  5.2485,
  1.5589,  1.5535,  1.5929,  1.6040,  1.6495,  1.7177,  1.8512,  1.9632,  2.1483,  2.4046,  2.6124,
  1.7357,  1.7445,  1.8162,  1.8437,  1.9171,  2.0118,  2.2209,  2.3386,  2.5901,  2.8861,  3.1765,
  2.1666,  2.2344,  2.3276,  2.4768,  2.6536,  2.8002,  3.2104,  3.2611,  3.6281,  4.1305,  4.5421,
  1.0772,  1.0857,  1.1073,  1.1617,  1.2426,  1.3875,  1.5546,  1.7487,  2.0529,  2.3995,  2.7098,
  1.1823,  1.1880,  1.2199,  1.2884,  1.3908,  1.5871,  1.7758,  2.0260,  2.3593,  2.7839,  3.1382,
  1.4296,  1.4406,  1.4694,  1.5778,  1.7233,  2.0092,  2.2344,  2.5848,  2.9662,  3.5482,  4.0745,
  0.7237,  0.7645,  0.8328,  0.9378,  1.0751,  1.2895,  1.5381,  1.8663,  2.3261,  2.8393,  3.4330,
  0.7862,  0.8294,  0.9062,  1.0326,  1.1925,  1.4421,  1.7365,  2.1337,  2.6533,  3.2670,  3.9419,
  0.9037,  0.9638,  1.0519,  1.2199,  1.4330,  1.7456,  2.1194,  2.6725,  3.3642,  4.1503,  4.9790,
  0.5467,  0.6007,  0.6866,  0.8130,  0.9859,  1.2339,  1.5821,  2.0456,  2.6540,  3.3963,  4.2299,
  0.5891,  0.6487,  0.7452,  0.8921,  1.0909,  1.3755,  1.7887,  2.2999,  3.0181,  3.8921,  4.8924,
  0.6838,  0.7443,  0.8815,  1.0545,  1.3124,  1.6632,  2.1944,  2.8609,  3.7833,  4.9126,  6.1264,
  0.4250,  0.4842,  0.5803,  0.7154,  0.9232,  1.2204,  1.6198,  2.2390,  3.0638,  4.1749,  5.4330,
  0.4552,  0.5247,  0.6297,  0.7900,  1.0152,  1.3646,  1.8021,  2.5403,  3.4783,  4.7740,  6.1917,
  0.5167,  0.6001,  0.7298,  0.9342,  1.1959,  1.6389,  2.2109,  3.1730,  4.3468,  5.9839,  7.7217,
  0.3710,  0.4261,  0.5309,  0.6715,  0.8860,  1.2013,  1.6701,  2.3602,  3.3203,  4.7376,  6.1706,
  0.4003,  0.4600,  0.5805,  0.7306,  0.9682,  1.3281,  1.8751,  2.6918,  3.8004,  5.4061,  7.1127,
  0.4537,  0.5211,  0.6741,  0.8521,  1.1634,  1.6042,  2.3248,  3.2706,  4.7547,  6.7218,  8.8981,
  0.3387,  0.3958,  0.4883,  0.6396,  0.8475,  1.1798,  1.6905,  2.4371,  3.5597,  5.0773,  6.8739,
  0.3630,  0.4253,  0.5309,  0.6942,  0.9375,  1.3148,  1.8895,  2.7440,  4.0129,  5.7700,  7.8796,
  0.4114,  0.4910,  0.6122,  0.8023,  1.1274,  1.5759,  2.3283,  3.3784,  4.9780,  7.1568,  9.8739),33,10,byrow=FALSE)

CUSUMfixedm_typeB_crit      <- array(NA,c(11,11,3))
CUSUMfixedm_typeB_crit[,,1] <- cbind(d_vec,A[1:11,])
CUSUMfixedm_typeB_crit[,,2] <- cbind(d_vec,A[12:22,])
CUSUMfixedm_typeB_crit[,,3] <- cbind(d_vec,A[23:33,])

dimnames(CUSUMfixedm_typeB_crit)[[2]] <- c("d_vec","1","2","3","4","10","25","50","100","150","200")
dimnames(CUSUMfixedm_typeB_crit)[[3]] <- c("90%", "95%", "99%")

##############################################################################################################################
##############################################################################################################################
##############################################################################################################################
##############################################################################################################################
##############################################################################################################################
CV_shift <- function(d,procedure,param)
{

if(procedure=="supwaldfixedb")    crit_matrix <- supwaldfixedb_crit
if(procedure=="cusumlm")          crit_matrix <- cusumlm_crit
if(procedure=="snwilcox")         crit_matrix <- snwilcox_crit
if(procedure=="snsupwald")        crit_matrix <- snsupwald_crit
if(procedure=="wilcoxonLM")       crit_matrix <- wilcoxonLM_crit
if(procedure=="CUSUMfixedb_typeA")crit_matrix <- CUSUMfixedb_typeA_crit
if(procedure=="CUSUMfixedb_typeB")crit_matrix <- CUSUMfixedb_typeB_crit
if(procedure=="CUSUMfixedm_typeA")crit_matrix <- CUSUMfixedm_typeA_crit
if(procedure=="CUSUMfixedm_typeB")crit_matrix <- CUSUMfixedm_typeB_crit

d_vec        <- crit_matrix[,1,1]
if(d<max(d_vec) & d>min(d_vec))
{
  tail       <- tail((crit_matrix[d_vec<=d,as.character(param),]),1)
  head       <- head((crit_matrix[d_vec>d,as.character(param),]),1)
  head2      <- min(d_vec[d_vec>d])
  tail2      <- max(d_vec[d_vec<=d])
  quo        <- as.numeric((d-tail2)/(head2-tail2))
  crit_value <- quo*head+(1-quo)*tail
}
if(d>=max(d_vec)) crit_value <- (crit_matrix[d_vec==max(d_vec),as.character(param),])
if(d<=min(d_vec)) crit_value <- (crit_matrix[d_vec==min(d_vec),as.character(param),])
return(as.vector(unlist(crit_value)))
}

