% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum_test.R
\name{cusum_test}
\alias{cusum_test}
\title{Cusum-type test against a change in persistence}
\usage{
cusum_test(x, trend = c("none", "linear"), tau = 0.2, type = c("LKT",
  "SK"), m = 0, simu = 0, M = 10000)
}
\arguments{
\item{x}{the univariate numeric time series to be investigated.}

\item{trend}{whether the time series exhibits a trend, \code{none} implies no trend and \code{linear} implies a linear trend.}

\item{tau}{the function tests in the interval \code{[T*tau,T*(1-tau)]} for a break in persistence with T being the length of the time series. It must hold that \code{0<tau<0.5}, default is \code{tau=0.2} as commonly used in the literature.}

\item{type}{which type of cusum test should be performed, \code{LKT} for the cusum test by Leybourne, Taylor, and Kim (2006) and \code{SK} for the extension by Sibbertsen and Kruse (2009). See details.}

\item{m}{Number of covariances used for the estimation of the long run variance. Default is \code{m=0}.}

\item{simu}{whether critical values should be simulated or interpolated, \code{simu=1} means simulation, \code{simu=0} means interpolation based on critical values for \code{tau=0.2}. See details. Default is \code{simu=0}.}

\item{M}{number of replications in case critical values should be simulated. Default is \code{M=10000}.}
}
\value{
Returns a matrix that consists of test statistic and critical values for testing against a change from nonstationary to stationary, stationary to nonstationary, and against a change in an unknown direction.
}
\description{
This function performs a cusum-type test for a change in persistence as suggested by Leybourne, Taylor, and Kim (2006) and extended by Sibbertsen and Kruse (2009).
Under the null hypothesis the time series is nonstationary throughout and under the alternative a change from nonstationary to stationary or vice versa has occured.
}
\details{
Leybourne, Taylor, and Kim (2006) introduced a cusum-type test that is able to identify when time series
exhibit changes in persistence.. Under the null
hypothesis, the series is throughout I(1), i.e. nonstationary. Under the alternative the series exhibits a
break either from I(0) to I(1) or vice versa. Sibbertsen and Kruse (2009) extended the test such that under the null hypothesis
the time series is I(d) throughout, with d>1/2 and under the alternative a change from I(d1) to I(d2), where d1<1/2 and 1/2<d2<3/2, or vice versa has occured.
While the test statistic remains the same, the critical values of the extended test change as they depend on the order of integration.
Furthermore, the procedure by SK integrates the series if d is estimated to be smaller than 1/2. This allows to overcome the problem of the approach by LKT which is that is has a degenerated limiting distribution when the series is stationary.
To determine the order of integration (the memory parameter d) the semiparametric estimator by Geweke and Porter-Hudak (1983) is used.

The critical values of the tests vary with sample size and d. If \code{simu=0}, the critical values provided
are based on linear interpolation of the critical values simulated by Leybourne, Taylor, and Kim (2006) respectively the response curves by Sibbertsen and Kruse (2009).
These are based on \code{tau=0.2}.
If \code{simu=1}, the critical values are simulated based on the given setup using M replications. Caution, for large M this might take a while,
small M, however, make the results unreliable.
}
\examples{
library(fracdiff)
series<- c(rnorm(200),cumsum(rnorm(200)))
cusum_test(series,trend="none",type="SK")
}
\references{
Leybourne, S., Kim, T., and Taylor, R. (2006): Cusum of squares-based tests for a change in persistence. Journal of Time Series Analysis, 28, pp. 408-433.

Sibbertsen, P. and Kruse, R. (2009): Testing for a break in persistence under long-range dependencies. Journal of Time Series Analysis, 30, pp. 263-285.
}
\author{
Janis Becker
}
