% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUSUM_simple.R
\name{CUSUM_simple}
\alias{CUSUM_simple}
\title{Simple test for change-in-mean under long memory}
\usage{
CUSUM_simple(tseries, d)
}
\arguments{
\item{tseries}{the univariate numeric time series to be investigated.}

\item{d}{the long-memory parameter.}
}
\value{
Returns the test statistic and the p-value of the test.
}
\description{
This function performs a CUSUM test on a change-in-mean that is robust under long memory. It is based on the fractionally differenced series where
the long-memory parameter is estimated by a consistent estimator.
The function returns the test statistic as well as the p-value of the test.
}
\examples{
library(fracdiff)
library(strucchange)
library(LongMemoryTS)

n        <- 500
d        <- 0.2
tseries  <- fracdiff.sim(n=n,d=d)$series
d_est    <- local.W(tseries, m=floor(1+n^0.65))$d

changep  <- c(rep(0,n/2),rep(1,n/2))
tseries2 <- tseries+changep
d_est2   <- local.W(tseries2, m=floor(1+n^0.65))$d

CUSUM_simple(tseries,d_est)
CUSUM_simple(tseries2,d_est2)
}
\references{
Wenger, K. and Leschinski, C. and Sibbertsen, P. (2018): A simple test on structural change in long-memory time series. Economics Letters, 136, pp. 90-94.
}
\author{
Kai Wenger
}
