% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{one_fluency_steps}
\alias{one_fluency_steps}
\title{Verbal fluency step counter}
\usage{
one_fluency_steps(adj_list, n, pjump = 0, type = 0L)
}
\arguments{
\item{adj_list}{a list containing row indices of nodes adjacent node to the ith
node as created by \link{get_adjlist}.}

\item{n}{integer specifying the number of productions.}

\item{pjump}{numeric specifying the probability of a jump.}

\item{type}{integer controlling network start and jump nodes.
For \code{type = 0} the process selects the start node and any jump
nodes proportional to their degree. For \code{type = 1} the process
selects a random node to serve both as the start node and the jump node.
For \code{type = 2} the process selects the start and any jump nodes
uniformly at random.}
}
\value{
Integer vector containing the indices of the fluency productions.
  Indices refer to the row of the item in the original adjacency matrix. See
  \link{get_adjlist}.
}
\description{
Generates verbal fluency data using a switcher-random walk process and counts
the number of steps required to produce \code{n} unique responses.
}
\details{
Function produces verbal fluency data via a switcher random walk
process that traverses the network by selecting a neighbor with
probability \code{1-pjump} or jumps to a random place in the network
with probability \code{pjump}. Where the random walk process enters
the network and where it jumps to is further controlled
by \code{type}. Neighbors are always selected uniformly.

In contrast to \link{fluency} and \code{ffluency}, returns the number of steps
required to produce a sequence of unique productions, rather than the
productions itself.
}
\examples{
# generate watts strogatz graph
network = grow_ws(n = 100, k = 10)

# count number of steps needed to create sequence
one_fluency_steps(get_adjlist(network), 10)

# count number of steps needed to create sequence
# with high jump probability
one_fluency_steps(get_adjlist(network), 10, pjump = .5)

}
\references{
Wulff, D. U., Hills, T., & Mata, R. (2018, October 29). Structural
differences in the semantic networks of younger and older adults.
https://doi.org/10.31234/osf.io/s73dp

Goni, J., Martincorena, I., Corominas-Murtra, B., Arrondo, G., Ardanza-
Trevijano, S., & Villoslada, P. (2010). Switcher-random-walks: A cognitive-
inspired mechanism for network exploration. International Journal of
Bifurcation and Chaos, 20(03), 913-922.
}
