% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_kneighbors}
\alias{get_kneighbors}
\title{Get vector of neighbors exactly k steps away}
\usage{
get_kneighbors(adj, start, k = 1L)
}
\arguments{
\item{adj}{numeric matrix specifying the adjacency matrix.}

\item{start}{integer specifying the row index of the start node in the
adjacency matrix.}

\item{k}{integer specifying the exact distance to the start node.}
}
\value{
A numeric vector containing node indices of nodes \code{k} or fewer
steps away from \code{start}.
}
\description{
Function iterates over graph to identify for a given node all nodes that are
exactly k steps apart.
}
\details{
\code{k < 1} will be set to \code{k = 1}.
}
\examples{

# generate watts strogatz graph
network = grow_ws(n = 100, k = 10, p = .5)

# get neighborhood of second node
get_kneighbors(network, 2)

# get 3-hop neighborhood of second node
get_kneighbors(network, 2, k = 3)

}
