% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/logL-methods.R
\name{logL}
\alias{logL}
\alias{logL,EL-method}
\alias{logL,ELT-method}
\title{Empirical log-likelihood}
\usage{
\S4method{logL}{EL}(object, ...)

\S4method{logL}{ELT}(object, ...)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL} or
\linkS4class{ELT}.}

\item{...}{Further arguments passed to methods.}
}
\value{
A single numeric.
}
\description{
Extracts empirical log-likelihood from a model.
}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
logL(fit)
}
\references{
Baggerly KA (1998).
  “Empirical Likelihood as a Goodness-of-Fit Measure.” \emph{Biometrika},
  85(3), 535--547. \doi{10.1093/biomet/asm094}.
}
\seealso{
\linkS4class{EL}, \linkS4class{ELT}
}
